/*
 * Decompiled with CFR 0.152.
 */
package tech.sirwellington.alchemy.generator;

import java.util.List;
import org.apache.commons.lang3.RandomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.sirwellington.alchemy.annotations.access.Internal;
import tech.sirwellington.alchemy.annotations.designs.patterns.StrategyPattern;
import tech.sirwellington.alchemy.generator.AlchemyGenerator;
import tech.sirwellington.alchemy.generator.BooleanGenerators;
import tech.sirwellington.alchemy.generator.Checks;

@StrategyPattern(role=StrategyPattern.Role.CONCRETE_BEHAVIOR)
public final class NumberGenerators {
    private static final Logger LOG = LoggerFactory.getLogger(NumberGenerators.class);

    private NumberGenerators() throws IllegalAccessException {
        throw new IllegalAccessException("cannot instantiate this class");
    }

    public static AlchemyGenerator<Integer> integers(int inclusiveLowerBound, int exclusiveUpperBound) throws IllegalArgumentException {
        Checks.checkThat(inclusiveLowerBound <= exclusiveUpperBound, "Upper Bound must be greater than Lower Bound");
        boolean isNegativeLowerBound = inclusiveLowerBound < 0;
        boolean isNegativeUpperBound = exclusiveUpperBound < 0;
        return () -> {
            if (isNegativeLowerBound && isNegativeUpperBound) {
                int min = -exclusiveUpperBound;
                int max = inclusiveLowerBound == Integer.MIN_VALUE ? Integer.MAX_VALUE : -inclusiveLowerBound;
                int dirtyValue = RandomUtils.nextInt((int)min, (int)max);
                int valueAdjustedForInclusiveness = NumberGenerators.safeIncrement(dirtyValue);
                return -valueAdjustedForInclusiveness;
            }
            if (isNegativeLowerBound) {
                boolean shouldProduceNegative = BooleanGenerators.booleans().get();
                if (shouldProduceNegative) {
                    int dirtyMax = inclusiveLowerBound == Integer.MIN_VALUE ? Integer.MAX_VALUE : -inclusiveLowerBound;
                    int maxAdjustedForInclusiveness = NumberGenerators.safeIncrement(dirtyMax);
                    return -RandomUtils.nextInt((int)0, (int)maxAdjustedForInclusiveness);
                }
                return RandomUtils.nextInt((int)0, (int)exclusiveUpperBound);
            }
            return RandomUtils.nextInt((int)inclusiveLowerBound, (int)exclusiveUpperBound);
        };
    }

    public static AlchemyGenerator<Integer> positiveIntegers() {
        return NumberGenerators.integers(1, Integer.MAX_VALUE);
    }

    public static AlchemyGenerator<Integer> smallPositiveIntegers() {
        return NumberGenerators.integers(1, 1000);
    }

    public static AlchemyGenerator<Integer> negativeIntegers() {
        return () -> {
            int value = NumberGenerators.positiveIntegers().get();
            return value < 0 ? value : -value;
        };
    }

    public static AlchemyGenerator<Long> longs(long inclusiveLowerBound, long exclusiveUpperBound) throws IllegalArgumentException {
        Checks.checkThat(inclusiveLowerBound <= exclusiveUpperBound, "Upper Bound must be greater than Lower Bound");
        boolean negativeLowerBound = inclusiveLowerBound < 0L;
        boolean negativeUpperBound = exclusiveUpperBound < 0L;
        return () -> {
            if (negativeLowerBound && negativeUpperBound) {
                long min = -exclusiveUpperBound;
                long max = inclusiveLowerBound == Long.MIN_VALUE ? Long.MAX_VALUE : -inclusiveLowerBound;
                long dirtyValue = RandomUtils.nextLong((long)min, (long)max);
                long valueAdjustedForInclusiveness = NumberGenerators.safeIncrement(dirtyValue);
                return -valueAdjustedForInclusiveness;
            }
            if (negativeLowerBound) {
                boolean shouldProduceNegative = BooleanGenerators.booleans().get();
                if (shouldProduceNegative) {
                    long min = 0L;
                    long dirtyMax = inclusiveLowerBound == Long.MIN_VALUE ? Long.MAX_VALUE : -inclusiveLowerBound;
                    long maxAdjustedForInclusiveness = NumberGenerators.safeIncrement(dirtyMax);
                    return -RandomUtils.nextLong((long)min, (long)maxAdjustedForInclusiveness);
                }
                return RandomUtils.nextLong((long)0L, (long)exclusiveUpperBound);
            }
            return RandomUtils.nextLong((long)inclusiveLowerBound, (long)exclusiveUpperBound);
        };
    }

    public static AlchemyGenerator<Long> positiveLongs() {
        return NumberGenerators.longs(1L, Long.MAX_VALUE);
    }

    public static AlchemyGenerator<Long> smallPositiveLongs() {
        return NumberGenerators.longs(1L, 10000L);
    }

    public static AlchemyGenerator<Double> doubles(double inclusiveLowerBound, double inclusiveUpperBound) throws IllegalArgumentException {
        Checks.checkThat(inclusiveLowerBound <= inclusiveUpperBound, "Upper Bound must be greater than Lower Bound");
        boolean negativeLowerBound = inclusiveLowerBound < 0.0;
        boolean negativeUpperBound = inclusiveUpperBound < 0.0;
        return () -> {
            if (negativeLowerBound && negativeUpperBound) {
                return -RandomUtils.nextDouble((double)(-inclusiveUpperBound), (double)(-inclusiveLowerBound));
            }
            if (negativeLowerBound) {
                boolean shouldProduceNegative = BooleanGenerators.booleans().get();
                if (shouldProduceNegative) {
                    return -RandomUtils.nextDouble((double)0.0, (double)(-inclusiveLowerBound));
                }
                return RandomUtils.nextDouble((double)0.0, (double)inclusiveUpperBound);
            }
            return RandomUtils.nextDouble((double)inclusiveLowerBound, (double)inclusiveUpperBound);
        };
    }

    public static AlchemyGenerator<Double> positiveDoubles() {
        return NumberGenerators.doubles(0.1, Double.MAX_VALUE);
    }

    public static AlchemyGenerator<Double> smallPositiveDoubles() {
        return NumberGenerators.doubles(0.1, 1000.0);
    }

    public static AlchemyGenerator<Integer> integersFromFixedList(List<Integer> values) {
        Checks.checkNotNull(values);
        Checks.checkThat(!values.isEmpty(), "No values specified");
        return () -> {
            int index = NumberGenerators.integers(0, values.size()).get();
            return (Integer)values.get(index);
        };
    }

    public static AlchemyGenerator<Double> doublesFromFixedList(List<Double> values) {
        Checks.checkNotNull(values);
        Checks.checkThat(!values.isEmpty(), "No values specified");
        return () -> {
            int index = NumberGenerators.integers(0, values.size()).get();
            return (Double)values.get(index);
        };
    }

    @Internal
    static long safeIncrement(long value) {
        return value == Long.MAX_VALUE ? value : value + 1L;
    }

    @Internal
    static long safeDecrement(long value) {
        return value == Long.MIN_VALUE ? value : value - 1L;
    }

    @Internal
    static int safeIncrement(int value) {
        return value == Integer.MAX_VALUE ? value : value + 1;
    }

    @Internal
    static int safeDecrement(int value) {
        return value == Integer.MIN_VALUE ? value : value - 1;
    }
}

