/*
 * Decompiled with CFR 0.152.
 */
package tech.sirwellington.alchemy.generator;

import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.sirwellington.alchemy.generator.Checks;
import tech.sirwellington.alchemy.generator.NumberGenerators;

public final class EnumGenerators {
    private static final Logger LOG = LoggerFactory.getLogger(EnumGenerators.class);

    public static <E extends Enum> Supplier<E> enumValueOf(Class<E> enumClass) {
        Checks.checkNotNull(enumClass);
        Enum[] constants = (Enum[])enumClass.getEnumConstants();
        Checks.checkThat(constants != null, "Class is not an Enum: " + enumClass.getName());
        Checks.checkThat(constants.length > 0, "Enum has no values");
        return () -> {
            int index = NumberGenerators.integers(0, constants.length).get();
            return constants[index];
        };
    }
}

