/*
 * Decompiled with CFR 0.152.
 */
package tech.sirwellington.alchemy.generator;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import tech.sirwellington.alchemy.annotations.access.NonInstantiable;
import tech.sirwellington.alchemy.generator.Checks;

@NonInstantiable
public final class Dates {
    Dates() throws IllegalAccessException {
        throw new IllegalAccessException("cannot instantiate class");
    }

    public static Date now() {
        return new Date();
    }

    public static Date daysAgo(int days) {
        Instant instant = Instant.now().minus(days, ChronoUnit.DAYS);
        return new Date(instant.toEpochMilli());
    }

    public static Date daysAhead(int days) {
        Instant instant = Instant.now().plus((long)days, ChronoUnit.DAYS);
        return new Date(instant.toEpochMilli());
    }

    public static Date hoursAgo(int hours) {
        Instant instant = Instant.now().minus(hours, ChronoUnit.HOURS);
        return new Date(instant.toEpochMilli());
    }

    public static Date hoursAhead(int hours) {
        Instant instant = Instant.now().plus((long)hours, ChronoUnit.HOURS);
        return new Date(instant.toEpochMilli());
    }

    public static Date minutesAgo(int minutes) {
        Instant instant = Instant.now().minus(minutes, ChronoUnit.MINUTES);
        return new Date(instant.toEpochMilli());
    }

    public static Date minutesAhead(int minutes) {
        Instant instant = Instant.now().plus((long)minutes, ChronoUnit.MINUTES);
        return new Date(instant.toEpochMilli());
    }

    public static boolean isNow(Date date) {
        return Dates.isNow(date, 5L);
    }

    public static boolean isNow(Date date, long marginOfErrorMillis) {
        Date now = Dates.now();
        Checks.checkNotNull(date);
        Checks.checkThat(marginOfErrorMillis >= 0L, "margin of error must be >= 0");
        long delta = marginOfErrorMillis;
        long timeOfDate = date.getTime();
        long timeOfNow = now.getTime();
        return timeOfDate >= timeOfNow - delta && timeOfDate <= timeOfNow + delta;
    }
}

