/*
 * Decompiled with CFR 0.152.
 */
package tech.sirwellington.alchemy.generator;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.sirwellington.alchemy.annotations.access.NonInstantiable;
import tech.sirwellington.alchemy.generator.AlchemyGenerator;
import tech.sirwellington.alchemy.generator.BooleanGenerators;
import tech.sirwellington.alchemy.generator.Checks;
import tech.sirwellington.alchemy.generator.Dates;
import tech.sirwellington.alchemy.generator.NumberGenerators;

@NonInstantiable
public final class DateGenerators {
    private static final Logger LOG = LoggerFactory.getLogger(DateGenerators.class);

    public static AlchemyGenerator<Date> now() {
        return () -> Dates.now();
    }

    public static AlchemyGenerator<Date> beforeNow() {
        return () -> {
            int amountBefore = AlchemyGenerator.one(NumberGenerators.smallPositiveIntegers());
            boolean useDaysInsteadOfHours = AlchemyGenerator.one(BooleanGenerators.booleans());
            if (useDaysInsteadOfHours) {
                return Dates.daysAgo(amountBefore);
            }
            return Dates.hoursAgo(amountBefore);
        };
    }

    public static AlchemyGenerator<Date> afterNow() {
        return () -> {
            int amountAfter = AlchemyGenerator.one(NumberGenerators.smallPositiveIntegers());
            boolean useDaysInsteadOfHours = AlchemyGenerator.one(BooleanGenerators.booleans());
            if (useDaysInsteadOfHours) {
                return Dates.daysAhead(amountAfter);
            }
            return Dates.hoursAhead(amountAfter);
        };
    }

    public static AlchemyGenerator<Date> anyTime() {
        return () -> {
            int branch = AlchemyGenerator.one(NumberGenerators.integers(1, 4));
            switch (branch) {
                case 1: {
                    return DateGenerators.now().get();
                }
                case 2: {
                    return DateGenerators.beforeNow().get();
                }
            }
            return DateGenerators.afterNow().get();
        };
    }

    public static AlchemyGenerator<Instant> asInstant(AlchemyGenerator<Date> dateGenerator) throws IllegalArgumentException {
        Checks.checkNotNull(dateGenerator);
        return () -> {
            Date date = (Date)dateGenerator.get();
            Checks.checkNotNull(date, "received null date");
            return Instant.ofEpochMilli(date.getTime());
        };
    }

    public static AlchemyGenerator<ZonedDateTime> asZonedDateTime(AlchemyGenerator<Date> dateGenerator) throws IllegalArgumentException {
        Checks.checkNotNull(dateGenerator);
        return () -> {
            Instant instant = DateGenerators.asInstant(dateGenerator).get();
            return ZonedDateTime.ofInstant(instant, ZoneId.systemDefault());
        };
    }
}

