/*
 * Decompiled with CFR 0.152.
 */
package tech.sirwellington.alchemy.generator;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.RandomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.sirwellington.alchemy.annotations.access.NonInstantiable;
import tech.sirwellington.alchemy.generator.AlchemyGenerator;

@NonInstantiable
public final class BooleanGenerators {
    private static final Logger LOG = LoggerFactory.getLogger(BooleanGenerators.class);

    private BooleanGenerators() throws IllegalAccessException {
        throw new IllegalAccessException("cannot instantiate this class");
    }

    public static AlchemyGenerator<Boolean> booleans() {
        return () -> RandomUtils.nextInt((int)0, (int)2) == 1;
    }

    public static AlchemyGenerator<Boolean> alternatingBooleans() {
        AtomicInteger count = new AtomicInteger();
        return () -> BooleanGenerators.isEven(count.incrementAndGet());
    }

    private static boolean isEven(int number) {
        return number % 2 == 0;
    }
}

