/*
 * Decompiled with CFR 0.152.
 */
package tech.sirwellington.alchemy.generator;

import org.apache.commons.lang3.RandomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.sirwellington.alchemy.annotations.access.NonInstantiable;
import tech.sirwellington.alchemy.generator.AlchemyGenerator;
import tech.sirwellington.alchemy.generator.Checks;

@NonInstantiable
public final class BinaryGenerators {
    private static final Logger LOG = LoggerFactory.getLogger(BinaryGenerators.class);

    private BinaryGenerators() throws IllegalAccessException {
        throw new IllegalAccessException("cannot instantiate this class");
    }

    public static AlchemyGenerator<byte[]> binary(int bytes) {
        Checks.checkThat(bytes > 0, "bytes must be at least 1");
        return () -> RandomUtils.nextBytes((int)bytes);
    }
}

