/*
 * Decompiled with CFR 0.152.
 */
package com.bymdev.voucherhub.api;

import com.bymdev.voucherhub.ApiCallback;
import com.bymdev.voucherhub.ApiClient;
import com.bymdev.voucherhub.ApiException;
import com.bymdev.voucherhub.ApiResponse;
import com.bymdev.voucherhub.Configuration;
import com.bymdev.voucherhub.Pair;
import com.bymdev.voucherhub.ProgressRequestBody;
import com.bymdev.voucherhub.ProgressResponseBody;
import com.bymdev.voucherhub.model.ExtraValidationParamDTO;
import com.bymdev.voucherhub.model.GenericStatusDTO;
import com.bymdev.voucherhub.model.JSONObject;
import com.bymdev.voucherhub.model.OrderNoteParamDTO;
import com.bymdev.voucherhub.model.ValidationResult;
import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class VoucherResourceApi {
    private ApiClient apiClient;

    public VoucherResourceApi() {
        this(Configuration.getDefaultApiClient());
    }

    public VoucherResourceApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call cancelValidationCall(String transactionTag, String reason, OrderNoteParamDTO note, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        OrderNoteParamDTO localVarPostBody = note;
        String localVarPath = "/api/v2/voucher/validate/cancel";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (transactionTag != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("transactionTag", transactionTag));
        }
        if (reason != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("reason", reason));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"X-Api-Key"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call cancelValidationValidateBeforeCall(String transactionTag, String reason, OrderNoteParamDTO note, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (transactionTag == null) {
            throw new ApiException("Missing the required parameter 'transactionTag' when calling cancelValidation(Async)");
        }
        Call call = this.cancelValidationCall(transactionTag, reason, note, progressListener, progressRequestListener);
        return call;
    }

    public GenericStatusDTO cancelValidation(String transactionTag, String reason, OrderNoteParamDTO note) throws ApiException {
        ApiResponse<GenericStatusDTO> resp = this.cancelValidationWithHttpInfo(transactionTag, reason, note);
        return resp.getData();
    }

    public ApiResponse<GenericStatusDTO> cancelValidationWithHttpInfo(String transactionTag, String reason, OrderNoteParamDTO note) throws ApiException {
        Call call = this.cancelValidationValidateBeforeCall(transactionTag, reason, note, null, null);
        Type localVarReturnType = new TypeToken<GenericStatusDTO>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call cancelValidationAsync(String transactionTag, String reason, OrderNoteParamDTO note, final ApiCallback<GenericStatusDTO> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.cancelValidationValidateBeforeCall(transactionTag, reason, note, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GenericStatusDTO>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call cancelVoucherCall(Long orderId, String voucherId, OrderNoteParamDTO note, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        OrderNoteParamDTO localVarPostBody = note;
        String localVarPath = "/api/v1/voucher/cancel";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (orderId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("orderId", orderId));
        }
        if (voucherId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("voucherId", voucherId));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"X-Api-Key"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call cancelVoucherValidateBeforeCall(Long orderId, String voucherId, OrderNoteParamDTO note, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (orderId == null) {
            throw new ApiException("Missing the required parameter 'orderId' when calling cancelVoucher(Async)");
        }
        Call call = this.cancelVoucherCall(orderId, voucherId, note, progressListener, progressRequestListener);
        return call;
    }

    public GenericStatusDTO cancelVoucher(Long orderId, String voucherId, OrderNoteParamDTO note) throws ApiException {
        ApiResponse<GenericStatusDTO> resp = this.cancelVoucherWithHttpInfo(orderId, voucherId, note);
        return resp.getData();
    }

    public ApiResponse<GenericStatusDTO> cancelVoucherWithHttpInfo(Long orderId, String voucherId, OrderNoteParamDTO note) throws ApiException {
        Call call = this.cancelVoucherValidateBeforeCall(orderId, voucherId, note, null, null);
        Type localVarReturnType = new TypeToken<GenericStatusDTO>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call cancelVoucherAsync(Long orderId, String voucherId, OrderNoteParamDTO note, final ApiCallback<GenericStatusDTO> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.cancelVoucherValidateBeforeCall(orderId, voucherId, note, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GenericStatusDTO>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call convertVoucherCall(String oldVoucherId, String newVoucherId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/voucher/convert";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (oldVoucherId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("oldVoucherId", oldVoucherId));
        }
        if (newVoucherId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("newVoucherId", newVoucherId));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"X-Api-Key"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call convertVoucherValidateBeforeCall(String oldVoucherId, String newVoucherId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (oldVoucherId == null) {
            throw new ApiException("Missing the required parameter 'oldVoucherId' when calling convertVoucher(Async)");
        }
        if (newVoucherId == null) {
            throw new ApiException("Missing the required parameter 'newVoucherId' when calling convertVoucher(Async)");
        }
        Call call = this.convertVoucherCall(oldVoucherId, newVoucherId, progressListener, progressRequestListener);
        return call;
    }

    public JSONObject convertVoucher(String oldVoucherId, String newVoucherId) throws ApiException {
        ApiResponse<JSONObject> resp = this.convertVoucherWithHttpInfo(oldVoucherId, newVoucherId);
        return resp.getData();
    }

    public ApiResponse<JSONObject> convertVoucherWithHttpInfo(String oldVoucherId, String newVoucherId) throws ApiException {
        Call call = this.convertVoucherValidateBeforeCall(oldVoucherId, newVoucherId, null, null);
        Type localVarReturnType = new TypeToken<JSONObject>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call convertVoucherAsync(String oldVoucherId, String newVoucherId, final ApiCallback<JSONObject> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.convertVoucherValidateBeforeCall(oldVoucherId, newVoucherId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<JSONObject>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call validateVoucherCall(String validationId, Long vendorId, String productTag, List<Long> orderItemIds, Boolean skipExpiryCheck, ExtraValidationParamDTO extraParamDTO, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        ExtraValidationParamDTO localVarPostBody = extraParamDTO;
        String localVarPath = "/api/v2/voucher/validate";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (validationId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("validationId", validationId));
        }
        if (vendorId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("vendorId", vendorId));
        }
        if (productTag != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("productTag", productTag));
        }
        if (orderItemIds != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "orderItemIds", orderItemIds));
        }
        if (skipExpiryCheck != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("skipExpiryCheck", skipExpiryCheck));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"X-Api-Key"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call validateVoucherValidateBeforeCall(String validationId, Long vendorId, String productTag, List<Long> orderItemIds, Boolean skipExpiryCheck, ExtraValidationParamDTO extraParamDTO, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (validationId == null) {
            throw new ApiException("Missing the required parameter 'validationId' when calling validateVoucher(Async)");
        }
        if (vendorId == null) {
            throw new ApiException("Missing the required parameter 'vendorId' when calling validateVoucher(Async)");
        }
        Call call = this.validateVoucherCall(validationId, vendorId, productTag, orderItemIds, skipExpiryCheck, extraParamDTO, progressListener, progressRequestListener);
        return call;
    }

    public ValidationResult validateVoucher(String validationId, Long vendorId, String productTag, List<Long> orderItemIds, Boolean skipExpiryCheck, ExtraValidationParamDTO extraParamDTO) throws ApiException {
        ApiResponse<ValidationResult> resp = this.validateVoucherWithHttpInfo(validationId, vendorId, productTag, orderItemIds, skipExpiryCheck, extraParamDTO);
        return resp.getData();
    }

    public ApiResponse<ValidationResult> validateVoucherWithHttpInfo(String validationId, Long vendorId, String productTag, List<Long> orderItemIds, Boolean skipExpiryCheck, ExtraValidationParamDTO extraParamDTO) throws ApiException {
        Call call = this.validateVoucherValidateBeforeCall(validationId, vendorId, productTag, orderItemIds, skipExpiryCheck, extraParamDTO, null, null);
        Type localVarReturnType = new TypeToken<ValidationResult>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call validateVoucherAsync(String validationId, Long vendorId, String productTag, List<Long> orderItemIds, Boolean skipExpiryCheck, ExtraValidationParamDTO extraParamDTO, final ApiCallback<ValidationResult> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.validateVoucherValidateBeforeCall(validationId, vendorId, productTag, orderItemIds, skipExpiryCheck, extraParamDTO, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<ValidationResult>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

