/*
 * Decompiled with CFR 0.152.
 */
package com.bymdev.voucherhub.api;

import com.bymdev.voucherhub.ApiCallback;
import com.bymdev.voucherhub.ApiClient;
import com.bymdev.voucherhub.ApiException;
import com.bymdev.voucherhub.ApiResponse;
import com.bymdev.voucherhub.Configuration;
import com.bymdev.voucherhub.Pair;
import com.bymdev.voucherhub.ProgressRequestBody;
import com.bymdev.voucherhub.ProgressResponseBody;
import com.bymdev.voucherhub.model.VendorDetailDTO;
import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class VendorResourceApi {
    private ApiClient apiClient;

    public VendorResourceApi() {
        this(Configuration.getDefaultApiClient());
    }

    public VendorResourceApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call getAllVendorsCall(String query, Integer size, Integer page, String sortBy, String sortOrder, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/vendors";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (query != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("query", query));
        }
        if (size != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("size", size));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page", page));
        }
        if (sortBy != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("sortBy", sortBy));
        }
        if (sortOrder != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("sortOrder", sortOrder));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"X-Api-Key"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getAllVendorsValidateBeforeCall(String query, Integer size, Integer page, String sortBy, String sortOrder, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getAllVendorsCall(query, size, page, sortBy, sortOrder, progressListener, progressRequestListener);
        return call;
    }

    public List<VendorDetailDTO> getAllVendors(String query, Integer size, Integer page, String sortBy, String sortOrder) throws ApiException {
        ApiResponse<List<VendorDetailDTO>> resp = this.getAllVendorsWithHttpInfo(query, size, page, sortBy, sortOrder);
        return resp.getData();
    }

    public ApiResponse<List<VendorDetailDTO>> getAllVendorsWithHttpInfo(String query, Integer size, Integer page, String sortBy, String sortOrder) throws ApiException {
        Call call = this.getAllVendorsValidateBeforeCall(query, size, page, sortBy, sortOrder, null, null);
        Type localVarReturnType = new TypeToken<List<VendorDetailDTO>>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getAllVendorsAsync(String query, Integer size, Integer page, String sortBy, String sortOrder, final ApiCallback<List<VendorDetailDTO>> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getAllVendorsValidateBeforeCall(query, size, page, sortBy, sortOrder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<VendorDetailDTO>>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

