/*
 * Decompiled with CFR 0.152.
 */
package com.bymdev.voucherhub.api;

import com.bymdev.voucherhub.ApiCallback;
import com.bymdev.voucherhub.ApiClient;
import com.bymdev.voucherhub.ApiException;
import com.bymdev.voucherhub.ApiResponse;
import com.bymdev.voucherhub.Configuration;
import com.bymdev.voucherhub.Pair;
import com.bymdev.voucherhub.ProgressRequestBody;
import com.bymdev.voucherhub.ProgressResponseBody;
import com.bymdev.voucherhub.model.ProductDTO;
import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ProductResourceApi {
    private ApiClient apiClient;

    public ProductResourceApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ProductResourceApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call findProductsByVendorCall(Long vendorId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/products/vendor/{vendorId}".replaceAll("\\{vendorId\\}", this.apiClient.escapeString(vendorId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"X-Api-Key"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call findProductsByVendorValidateBeforeCall(Long vendorId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (vendorId == null) {
            throw new ApiException("Missing the required parameter 'vendorId' when calling findProductsByVendor(Async)");
        }
        Call call = this.findProductsByVendorCall(vendorId, progressListener, progressRequestListener);
        return call;
    }

    public List<ProductDTO> findProductsByVendor(Long vendorId) throws ApiException {
        ApiResponse<List<ProductDTO>> resp = this.findProductsByVendorWithHttpInfo(vendorId);
        return resp.getData();
    }

    public ApiResponse<List<ProductDTO>> findProductsByVendorWithHttpInfo(Long vendorId) throws ApiException {
        Call call = this.findProductsByVendorValidateBeforeCall(vendorId, null, null);
        Type localVarReturnType = new TypeToken<List<ProductDTO>>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call findProductsByVendorAsync(Long vendorId, final ApiCallback<List<ProductDTO>> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.findProductsByVendorValidateBeforeCall(vendorId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<ProductDTO>>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getAllProductsCall(String query, Integer size, Integer page, String sortBy, String sortOrder, String type, List<String> tagFilter, String tagFilterMode, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/products";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (query != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("query", query));
        }
        if (size != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("size", size));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page", page));
        }
        if (sortBy != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("sortBy", sortBy));
        }
        if (sortOrder != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("sortOrder", sortOrder));
        }
        if (type != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("type", type));
        }
        if (tagFilter != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("csv", "tagFilter", tagFilter));
        }
        if (tagFilterMode != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("tagFilterMode", tagFilterMode));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"X-Api-Key"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getAllProductsValidateBeforeCall(String query, Integer size, Integer page, String sortBy, String sortOrder, String type, List<String> tagFilter, String tagFilterMode, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getAllProductsCall(query, size, page, sortBy, sortOrder, type, tagFilter, tagFilterMode, progressListener, progressRequestListener);
        return call;
    }

    public List<ProductDTO> getAllProducts(String query, Integer size, Integer page, String sortBy, String sortOrder, String type, List<String> tagFilter, String tagFilterMode) throws ApiException {
        ApiResponse<List<ProductDTO>> resp = this.getAllProductsWithHttpInfo(query, size, page, sortBy, sortOrder, type, tagFilter, tagFilterMode);
        return resp.getData();
    }

    public ApiResponse<List<ProductDTO>> getAllProductsWithHttpInfo(String query, Integer size, Integer page, String sortBy, String sortOrder, String type, List<String> tagFilter, String tagFilterMode) throws ApiException {
        Call call = this.getAllProductsValidateBeforeCall(query, size, page, sortBy, sortOrder, type, tagFilter, tagFilterMode, null, null);
        Type localVarReturnType = new TypeToken<List<ProductDTO>>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getAllProductsAsync(String query, Integer size, Integer page, String sortBy, String sortOrder, String type, List<String> tagFilter, String tagFilterMode, final ApiCallback<List<ProductDTO>> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getAllProductsValidateBeforeCall(query, size, page, sortBy, sortOrder, type, tagFilter, tagFilterMode, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<ProductDTO>>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

