/*
 * Decompiled with CFR 0.152.
 */
package com.bymdev.voucherhub.api;

import com.bymdev.voucherhub.ApiCallback;
import com.bymdev.voucherhub.ApiClient;
import com.bymdev.voucherhub.ApiException;
import com.bymdev.voucherhub.ApiResponse;
import com.bymdev.voucherhub.Configuration;
import com.bymdev.voucherhub.Pair;
import com.bymdev.voucherhub.ProgressRequestBody;
import com.bymdev.voucherhub.ProgressResponseBody;
import com.bymdev.voucherhub.model.GenericStatusDTO;
import com.bymdev.voucherhub.model.OrderRecordDTO;
import com.bymdev.voucherhub.model.OrderRecordExtendDTO;
import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class OrderRecordResourceApi {
    private ApiClient apiClient;

    public OrderRecordResourceApi() {
        this(Configuration.getDefaultApiClient());
    }

    public OrderRecordResourceApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call createOrderRecordCall(OrderRecordDTO orderRecordDto, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        OrderRecordDTO localVarPostBody = orderRecordDto;
        String localVarPath = "/api/v1/orderRecords";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"X-Api-Key"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call createOrderRecordValidateBeforeCall(OrderRecordDTO orderRecordDto, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (orderRecordDto == null) {
            throw new ApiException("Missing the required parameter 'orderRecordDto' when calling createOrderRecord(Async)");
        }
        Call call = this.createOrderRecordCall(orderRecordDto, progressListener, progressRequestListener);
        return call;
    }

    public OrderRecordDTO createOrderRecord(OrderRecordDTO orderRecordDto) throws ApiException {
        ApiResponse<OrderRecordDTO> resp = this.createOrderRecordWithHttpInfo(orderRecordDto);
        return resp.getData();
    }

    public ApiResponse<OrderRecordDTO> createOrderRecordWithHttpInfo(OrderRecordDTO orderRecordDto) throws ApiException {
        Call call = this.createOrderRecordValidateBeforeCall(orderRecordDto, null, null);
        Type localVarReturnType = new TypeToken<OrderRecordDTO>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call createOrderRecordAsync(OrderRecordDTO orderRecordDto, final ApiCallback<OrderRecordDTO> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.createOrderRecordValidateBeforeCall(orderRecordDto, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<OrderRecordDTO>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getAllOrderRecordsCall(String query, String from, String till, String timeZone, String deliveryMethod, String deliveryStatus, Integer size, Integer page, String sortBy, String sortOrder, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v2/orderRecords";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (query != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("query", query));
        }
        if (from != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("from", from));
        }
        if (till != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("till", till));
        }
        if (timeZone != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("timeZone", timeZone));
        }
        if (deliveryMethod != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("deliveryMethod", deliveryMethod));
        }
        if (deliveryStatus != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("deliveryStatus", deliveryStatus));
        }
        if (size != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("size", size));
        }
        if (page != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("page", page));
        }
        if (sortBy != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("sortBy", sortBy));
        }
        if (sortOrder != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("sortOrder", sortOrder));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"X-Api-Key"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getAllOrderRecordsValidateBeforeCall(String query, String from, String till, String timeZone, String deliveryMethod, String deliveryStatus, Integer size, Integer page, String sortBy, String sortOrder, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Call call = this.getAllOrderRecordsCall(query, from, till, timeZone, deliveryMethod, deliveryStatus, size, page, sortBy, sortOrder, progressListener, progressRequestListener);
        return call;
    }

    public List<OrderRecordExtendDTO> getAllOrderRecords(String query, String from, String till, String timeZone, String deliveryMethod, String deliveryStatus, Integer size, Integer page, String sortBy, String sortOrder) throws ApiException {
        ApiResponse<List<OrderRecordExtendDTO>> resp = this.getAllOrderRecordsWithHttpInfo(query, from, till, timeZone, deliveryMethod, deliveryStatus, size, page, sortBy, sortOrder);
        return resp.getData();
    }

    public ApiResponse<List<OrderRecordExtendDTO>> getAllOrderRecordsWithHttpInfo(String query, String from, String till, String timeZone, String deliveryMethod, String deliveryStatus, Integer size, Integer page, String sortBy, String sortOrder) throws ApiException {
        Call call = this.getAllOrderRecordsValidateBeforeCall(query, from, till, timeZone, deliveryMethod, deliveryStatus, size, page, sortBy, sortOrder, null, null);
        Type localVarReturnType = new TypeToken<List<OrderRecordExtendDTO>>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getAllOrderRecordsAsync(String query, String from, String till, String timeZone, String deliveryMethod, String deliveryStatus, Integer size, Integer page, String sortBy, String sortOrder, final ApiCallback<List<OrderRecordExtendDTO>> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getAllOrderRecordsValidateBeforeCall(query, from, till, timeZone, deliveryMethod, deliveryStatus, size, page, sortBy, sortOrder, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<List<OrderRecordExtendDTO>>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call getOrderRecordCall(Long id, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/orderRecords/{id}".replaceAll("\\{id\\}", this.apiClient.escapeString(id.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"X-Api-Key"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call getOrderRecordValidateBeforeCall(Long id, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (id == null) {
            throw new ApiException("Missing the required parameter 'id' when calling getOrderRecord(Async)");
        }
        Call call = this.getOrderRecordCall(id, progressListener, progressRequestListener);
        return call;
    }

    public OrderRecordExtendDTO getOrderRecord(Long id) throws ApiException {
        ApiResponse<OrderRecordExtendDTO> resp = this.getOrderRecordWithHttpInfo(id);
        return resp.getData();
    }

    public ApiResponse<OrderRecordExtendDTO> getOrderRecordWithHttpInfo(Long id) throws ApiException {
        Call call = this.getOrderRecordValidateBeforeCall(id, null, null);
        Type localVarReturnType = new TypeToken<OrderRecordExtendDTO>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call getOrderRecordAsync(Long id, final ApiCallback<OrderRecordExtendDTO> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.getOrderRecordValidateBeforeCall(id, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<OrderRecordExtendDTO>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call mergeVouchersCall(Long orderId, String newVoucherId, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/api/v1/orderRecords/mergeVouchers";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (orderId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("orderId", orderId));
        }
        if (newVoucherId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("newVoucherId", newVoucherId));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"X-Api-Key"};
        return this.apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call mergeVouchersValidateBeforeCall(Long orderId, String newVoucherId, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (orderId == null) {
            throw new ApiException("Missing the required parameter 'orderId' when calling mergeVouchers(Async)");
        }
        if (newVoucherId == null) {
            throw new ApiException("Missing the required parameter 'newVoucherId' when calling mergeVouchers(Async)");
        }
        Call call = this.mergeVouchersCall(orderId, newVoucherId, progressListener, progressRequestListener);
        return call;
    }

    public GenericStatusDTO mergeVouchers(Long orderId, String newVoucherId) throws ApiException {
        ApiResponse<GenericStatusDTO> resp = this.mergeVouchersWithHttpInfo(orderId, newVoucherId);
        return resp.getData();
    }

    public ApiResponse<GenericStatusDTO> mergeVouchersWithHttpInfo(Long orderId, String newVoucherId) throws ApiException {
        Call call = this.mergeVouchersValidateBeforeCall(orderId, newVoucherId, null, null);
        Type localVarReturnType = new TypeToken<GenericStatusDTO>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call mergeVouchersAsync(Long orderId, String newVoucherId, final ApiCallback<GenericStatusDTO> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.mergeVouchersValidateBeforeCall(orderId, newVoucherId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<GenericStatusDTO>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }

    public Call updateOrderRecordCall(OrderRecordDTO orderRecordDto, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        OrderRecordDTO localVarPostBody = orderRecordDto;
        String localVarPath = "/api/v1/orderRecords";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"X-Api-Key"};
        return this.apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call updateOrderRecordValidateBeforeCall(OrderRecordDTO orderRecordDto, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (orderRecordDto == null) {
            throw new ApiException("Missing the required parameter 'orderRecordDto' when calling updateOrderRecord(Async)");
        }
        Call call = this.updateOrderRecordCall(orderRecordDto, progressListener, progressRequestListener);
        return call;
    }

    public OrderRecordDTO updateOrderRecord(OrderRecordDTO orderRecordDto) throws ApiException {
        ApiResponse<OrderRecordDTO> resp = this.updateOrderRecordWithHttpInfo(orderRecordDto);
        return resp.getData();
    }

    public ApiResponse<OrderRecordDTO> updateOrderRecordWithHttpInfo(OrderRecordDTO orderRecordDto) throws ApiException {
        Call call = this.updateOrderRecordValidateBeforeCall(orderRecordDto, null, null);
        Type localVarReturnType = new TypeToken<OrderRecordDTO>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call updateOrderRecordAsync(OrderRecordDTO orderRecordDto, final ApiCallback<OrderRecordDTO> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.updateOrderRecordValidateBeforeCall(orderRecordDto, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<OrderRecordDTO>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

