/*
 * Decompiled with CFR 0.152.
 */
package com.arellomobile.mvp.compiler;

import com.arellomobile.mvp.MvpPresenter;
import com.arellomobile.mvp.MvpView;
import com.arellomobile.mvp.compiler.AnnotationRule;
import com.arellomobile.mvp.compiler.MvpCompiler;
import com.arellomobile.mvp.compiler.Util;
import com.arellomobile.mvp.presenter.InjectPresenter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.tools.Diagnostic;

public class PresenterInjectorRules
extends AnnotationRule {
    public PresenterInjectorRules(ElementKind validKind, Modifier ... validModifiers) {
        super(validKind, validModifiers);
    }

    @Override
    public void checkAnnotation(Element annotatedField) {
        this.checkEnvironment(annotatedField);
        if (annotatedField.getKind() != this.mValidKind) {
            this.mErrorBuilder.append("Field " + annotatedField + " of " + annotatedField.getEnclosingElement().getSimpleName() + " should be " + this.mValidKind.name() + ", or not mark it as @" + InjectPresenter.class.getSimpleName()).append("\n");
        }
        for (Modifier modifier : annotatedField.getModifiers()) {
            if (this.mValidModifiers.contains((Object)modifier)) continue;
            this.mErrorBuilder.append("Field " + annotatedField + " of " + annotatedField.getEnclosingElement().getSimpleName() + " can't be a " + (Object)((Object)modifier)).append(". Use ").append(this.validModifiersToString()).append("\n");
        }
        Element enclosingElement = annotatedField.getEnclosingElement();
        while (enclosingElement.getKind() == ElementKind.CLASS) {
            if (!enclosingElement.getModifiers().contains((Object)Modifier.PUBLIC)) {
                this.mErrorBuilder.append(enclosingElement.getSimpleName() + " should be PUBLIC ");
                break;
            }
            enclosingElement = enclosingElement.getEnclosingElement();
        }
    }

    private void checkEnvironment(Element annotatedField) {
        if (!(annotatedField.asType() instanceof DeclaredType)) {
            return;
        }
        TypeElement typeElement = (TypeElement)((DeclaredType)annotatedField.asType()).asElement();
        String viewClassFromGeneric = this.getViewClassFromGeneric(typeElement, (DeclaredType)annotatedField.asType());
        Collection<TypeMirror> viewsType = this.getViewsType((TypeElement)((DeclaredType)annotatedField.getEnclosingElement().asType()).asElement());
        boolean result = false;
        for (TypeMirror typeMirror : viewsType) {
            if (!Util.getFullClassName(typeMirror).equals(viewClassFromGeneric) && !Util.fillGenerics(Collections.emptyMap(), typeMirror).equals(viewClassFromGeneric)) continue;
            result = true;
            break;
        }
        if (!result) {
            MvpCompiler.getMessager().printMessage(Diagnostic.Kind.ERROR, "You can not use @InjectPresenter in classes that are not View, which is typified target Presenter", annotatedField);
        }
    }

    private String getViewClassFromGeneric(TypeElement typeElement, DeclaredType declaredType) {
        TypeMirror superclass = declaredType;
        Map<Object, Object> mTypedMap = Collections.emptyMap();
        if (!typeElement.getTypeParameters().isEmpty()) {
            mTypedMap = this.getChildInstanceOfClassFromGeneric(typeElement, MvpView.class);
        }
        Map<String, String> parentTypes = Collections.emptyMap();
        ArrayList<? extends TypeMirror> totalTypeArguments = new ArrayList<TypeMirror>(superclass.getTypeArguments());
        while (superclass.getKind() != TypeKind.NONE) {
            TypeElement superclassElement = (TypeElement)superclass.asElement();
            List<? extends TypeMirror> typeArguments = superclass.getTypeArguments();
            totalTypeArguments.retainAll(typeArguments);
            List<? extends TypeParameterElement> typeParameters = superclassElement.getTypeParameters();
            HashMap<String, String> types = new HashMap<String, String>();
            for (int i = 0; i < typeArguments.size(); ++i) {
                types.put(typeParameters.get(i).toString(), Util.fillGenerics(parentTypes, typeArguments.get(i)));
            }
            if (superclassElement.toString().equals(MvpPresenter.class.getCanonicalName())) {
                TypeMirror typeMirror;
                if (!typeArguments.isEmpty() && (typeMirror = typeArguments.get(0)) instanceof TypeVariable) {
                    Element key = ((TypeVariable)typeMirror).asElement();
                    for (Map.Entry<Object, Object> entry : mTypedMap.entrySet()) {
                        if (!((TypeParameterElement)entry.getKey()).toString().equals(key.toString())) continue;
                        return Util.getFullClassName((TypeMirror)entry.getValue());
                    }
                }
                if (typeArguments.isEmpty() && typeParameters.isEmpty()) {
                    return superclass.asElement().getSimpleName().toString();
                }
                return Util.fillGenerics(parentTypes, typeArguments);
            }
            parentTypes = types;
            superclass = superclassElement.getSuperclass();
        }
        return "";
    }

    private Map<TypeParameterElement, TypeMirror> getChildInstanceOfClassFromGeneric(TypeElement typeElement, Class<?> aClass) {
        HashMap<TypeParameterElement, TypeMirror> result = new HashMap<TypeParameterElement, TypeMirror>();
        block0: for (TypeParameterElement typeParameterElement : typeElement.getTypeParameters()) {
            List<? extends TypeMirror> bounds = typeParameterElement.getBounds();
            for (TypeMirror typeMirror : bounds) {
                if (!(typeMirror instanceof DeclaredType) || !(((DeclaredType)typeMirror).asElement() instanceof TypeElement)) continue;
                Collection<TypeMirror> viewsType = this.getViewsType((TypeElement)((DeclaredType)typeMirror).asElement());
                boolean isViewType = false;
                for (TypeMirror viewType : viewsType) {
                    if (!((DeclaredType)viewType).asElement().toString().equals(aClass.getCanonicalName())) continue;
                    isViewType = true;
                }
                if (!isViewType) continue;
                result.put(typeParameterElement, typeMirror);
                continue block0;
            }
        }
        return result;
    }

    private Collection<TypeMirror> getViewsType(TypeElement typeElement) {
        TypeMirror superclass = typeElement.asType();
        ArrayList<TypeMirror> result = new ArrayList<TypeMirror>();
        while (superclass.getKind() != TypeKind.NONE) {
            TypeElement superclassElement = (TypeElement)((DeclaredType)superclass).asElement();
            HashSet<? extends TypeMirror> interfaces = new HashSet<TypeMirror>(superclassElement.getInterfaces());
            for (TypeMirror typeMirror : interfaces) {
                if (!(typeMirror instanceof DeclaredType)) continue;
                result.addAll(this.getViewsType((TypeElement)((DeclaredType)typeMirror).asElement()));
            }
            result.addAll(interfaces);
            result.add(superclass);
            superclass = superclassElement.getSuperclass();
        }
        return result;
    }
}

