/*
 * Decompiled with CFR 0.152.
 */
package com.arellomobile.mvp.compiler.reflector;

import com.arellomobile.mvp.ViewStateProvider;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.WildcardTypeName;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;

public class MoxyReflectorGenerator {
    private static final Comparator<TypeElement> TYPE_ELEMENT_COMPARATOR = Comparator.comparing(Object::toString);
    private static final TypeName CLASS_WILDCARD_TYPE_NAME = ParameterizedTypeName.get((ClassName)ClassName.get(Class.class), (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf((TypeName)TypeName.OBJECT)});
    private static final TypeName LIST_OF_OBJECT_TYPE_NAME = ParameterizedTypeName.get((ClassName)ClassName.get(List.class), (TypeName[])new TypeName[]{TypeName.OBJECT});
    private static final TypeName MAP_CLASS_TO_OBJECT_TYPE_NAME = ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{CLASS_WILDCARD_TYPE_NAME, TypeName.OBJECT});
    private static final TypeName MAP_CLASS_TO_LIST_OF_OBJECT_TYPE_NAME = ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{CLASS_WILDCARD_TYPE_NAME, LIST_OF_OBJECT_TYPE_NAME});

    public static JavaFile generate(String destinationPackage, List<TypeElement> presenterClassNames, List<TypeElement> presentersContainers, List<TypeElement> strategyClasses, List<String> additionalMoxyReflectorsPackages) {
        TypeSpec.Builder classBuilder = TypeSpec.classBuilder((String)"MoxyReflector").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addField(MAP_CLASS_TO_OBJECT_TYPE_NAME, "sViewStateProviders", new Modifier[]{Modifier.PRIVATE, Modifier.STATIC}).addField(MAP_CLASS_TO_LIST_OF_OBJECT_TYPE_NAME, "sPresenterBinders", new Modifier[]{Modifier.PRIVATE, Modifier.STATIC}).addField(MAP_CLASS_TO_OBJECT_TYPE_NAME, "sStrategies", new Modifier[]{Modifier.PRIVATE, Modifier.STATIC});
        classBuilder.addStaticBlock(MoxyReflectorGenerator.generateStaticInitializer(presenterClassNames, presentersContainers, strategyClasses, additionalMoxyReflectorsPackages));
        if (destinationPackage.equals("com.arellomobile.mvp")) {
            classBuilder.addMethod(MethodSpec.methodBuilder((String)"getViewState").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns(Object.class).addParameter(CLASS_WILDCARD_TYPE_NAME, "presenterClass", new Modifier[0]).addStatement("$1T viewStateProvider = ($1T) sViewStateProviders.get(presenterClass)", new Object[]{ViewStateProvider.class}).beginControlFlow("if (viewStateProvider == null)", new Object[0]).addStatement("return null", new Object[0]).endControlFlow().addCode("\n", new Object[0]).addStatement("return viewStateProvider.getViewState()", new Object[0]).build());
            classBuilder.addMethod(MethodSpec.methodBuilder((String)"getPresenterBinders").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)ParameterizedTypeName.get(List.class, (Type[])new Type[]{Object.class})).addParameter(CLASS_WILDCARD_TYPE_NAME, "delegated", new Modifier[0]).addStatement("return sPresenterBinders.get(delegated)", new Object[0]).build());
            classBuilder.addMethod(MethodSpec.methodBuilder((String)"getStrategy").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns(Object.class).addParameter(CLASS_WILDCARD_TYPE_NAME, "strategyClass", new Modifier[0]).addStatement("return sStrategies.get(strategyClass)", new Object[0]).build());
        } else {
            classBuilder.addMethod(MethodSpec.methodBuilder((String)"getViewStateProviders").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns(MAP_CLASS_TO_OBJECT_TYPE_NAME).addStatement("return sViewStateProviders", new Object[0]).build());
            classBuilder.addMethod(MethodSpec.methodBuilder((String)"getPresenterBinders").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns(MAP_CLASS_TO_LIST_OF_OBJECT_TYPE_NAME).addStatement("return sPresenterBinders", new Object[0]).build());
            classBuilder.addMethod(MethodSpec.methodBuilder((String)"getStrategies").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns(MAP_CLASS_TO_OBJECT_TYPE_NAME).addStatement("return sStrategies", new Object[0]).build());
        }
        return JavaFile.builder((String)destinationPackage, (TypeSpec)classBuilder.build()).indent("\t").build();
    }

    private static CodeBlock generateStaticInitializer(List<TypeElement> presenterClassNames, List<TypeElement> presentersContainers, List<TypeElement> strategyClasses, List<String> additionalMoxyReflectorsPackages) {
        SortedMap<TypeElement, List<TypeElement>> presenterBinders = MoxyReflectorGenerator.getPresenterBinders(presentersContainers);
        presenterClassNames.sort(TYPE_ELEMENT_COMPARATOR);
        strategyClasses.sort(TYPE_ELEMENT_COMPARATOR);
        additionalMoxyReflectorsPackages.sort(Comparator.naturalOrder());
        CodeBlock.Builder builder = CodeBlock.builder();
        builder.addStatement("sViewStateProviders = new $T<>()", new Object[]{HashMap.class});
        for (TypeElement typeElement : presenterClassNames) {
            ClassName presenterClassName = ClassName.get((TypeElement)typeElement);
            ClassName viewStateProvider = ClassName.get((String)presenterClassName.packageName(), (String)(String.join((CharSequence)"$", presenterClassName.simpleNames()) + "$$ViewStateProvider"), (String[])new String[0]);
            builder.addStatement("sViewStateProviders.put($T.class, new $T())", new Object[]{presenterClassName, viewStateProvider});
        }
        builder.add("\n", new Object[0]);
        builder.addStatement("sPresenterBinders = new $T<>()", new Object[]{HashMap.class});
        for (Map.Entry entry : presenterBinders.entrySet()) {
            builder.add("sPresenterBinders.put($T.class, $T.<Object>asList(", new Object[]{entry.getKey(), Arrays.class});
            boolean isFirst = true;
            for (TypeElement typeElement : (List)entry.getValue()) {
                ClassName className = ClassName.get((TypeElement)typeElement);
                String presenterBinderName = String.join((CharSequence)"$", className.simpleNames()) + "$$PresentersBinder";
                if (isFirst) {
                    isFirst = false;
                } else {
                    builder.add(", ", new Object[0]);
                }
                builder.add("new $T()", new Object[]{ClassName.get((String)className.packageName(), (String)presenterBinderName, (String[])new String[0])});
            }
            builder.add("));\n", new Object[0]);
        }
        builder.add("\n", new Object[0]);
        builder.addStatement("sStrategies = new $T<>()", new Object[]{HashMap.class});
        for (TypeElement typeElement : strategyClasses) {
            builder.addStatement("sStrategies.put($1T.class, new $1T())", new Object[]{typeElement});
        }
        for (String string : additionalMoxyReflectorsPackages) {
            ClassName moxyReflector = ClassName.get((String)string, (String)"MoxyReflector", (String[])new String[0]);
            builder.add("\n", new Object[0]);
            builder.addStatement("sViewStateProviders.putAll($T.getViewStateProviders())", new Object[]{moxyReflector});
            builder.addStatement("sPresenterBinders.putAll($T.getPresenterBinders())", new Object[]{moxyReflector});
            builder.addStatement("sStrategies.putAll($T.getStrategies())", new Object[]{moxyReflector});
        }
        return builder.build();
    }

    private static SortedMap<TypeElement, List<TypeElement>> getPresenterBinders(List<TypeElement> presentersContainers) {
        HashMap<TypeElement, TypeElement> extendingMap = new HashMap<TypeElement, TypeElement>();
        for (TypeElement presentersContainer : presentersContainers) {
            TypeMirror superclass = presentersContainer.getSuperclass();
            TypeElement parent = null;
            while (superclass.getKind() == TypeKind.DECLARED) {
                TypeElement superclassElement = (TypeElement)((DeclaredType)superclass).asElement();
                if (presentersContainers.contains(superclassElement)) {
                    parent = superclassElement;
                    break;
                }
                superclass = superclassElement.getSuperclass();
            }
            extendingMap.put(presentersContainer, parent);
        }
        TreeMap<TypeElement, List<TypeElement>> elementListMap = new TreeMap<TypeElement, List<TypeElement>>(TYPE_ELEMENT_COMPARATOR);
        for (TypeElement presentersContainer : presentersContainers) {
            ArrayList<TypeElement> typeElements = new ArrayList<TypeElement>();
            typeElements.add(presentersContainer);
            TypeElement key = presentersContainer;
            while ((key = (TypeElement)extendingMap.get(key)) != null) {
                typeElements.add(key);
            }
            elementListMap.put(presentersContainer, typeElements);
        }
        return elementListMap;
    }
}

