/*
 * Decompiled with CFR 0.152.
 */
package com.arellomobile.mvp;

import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.support.v7.app.AppCompatDialogFragment;
import com.arellomobile.mvp.MvpDelegate;

public class MvpAppCompatDialogFragment
extends AppCompatDialogFragment {
    private boolean mIsStateSaved;
    private MvpDelegate<? extends MvpAppCompatDialogFragment> mMvpDelegate;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.getMvpDelegate().onCreate(savedInstanceState);
    }

    public void onResume() {
        super.onResume();
        this.mIsStateSaved = false;
        this.getMvpDelegate().onAttach();
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        this.mIsStateSaved = true;
        this.getMvpDelegate().onSaveInstanceState(outState);
        this.getMvpDelegate().onDetach();
    }

    public void onStop() {
        super.onStop();
        this.getMvpDelegate().onDetach();
    }

    public void onDestroyView() {
        super.onDestroyView();
        this.getMvpDelegate().onDetach();
        this.getMvpDelegate().onDestroyView();
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.getActivity().isFinishing()) {
            this.getMvpDelegate().onDestroy();
            return;
        }
        if (this.mIsStateSaved) {
            this.mIsStateSaved = false;
            return;
        }
        boolean anyParentIsRemoving = false;
        for (Fragment parent = this.getParentFragment(); !anyParentIsRemoving && parent != null; parent = parent.getParentFragment()) {
            anyParentIsRemoving = parent.isRemoving();
        }
        if (this.isRemoving() || anyParentIsRemoving) {
            this.getMvpDelegate().onDestroy();
        }
    }

    public MvpDelegate getMvpDelegate() {
        if (this.mMvpDelegate == null) {
            this.mMvpDelegate = new MvpDelegate((Object)this);
        }
        return this.mMvpDelegate;
    }
}

