/*
 * Decompiled with CFR 0.152.
 */
package com.arellomobile.mvp;

import android.app.DialogFragment;
import android.app.Fragment;
import android.os.Build;
import android.os.Bundle;
import com.arellomobile.mvp.MvpDelegate;

public class MvpDialogFragment
extends DialogFragment {
    private boolean mIsStateSaved;
    private MvpDelegate<? extends MvpDialogFragment> mMvpDelegate;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.getMvpDelegate().onCreate(savedInstanceState);
    }

    public void onResume() {
        super.onResume();
        this.mIsStateSaved = false;
        this.getMvpDelegate().onAttach();
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        this.mIsStateSaved = true;
        this.getMvpDelegate().onSaveInstanceState(outState);
        this.getMvpDelegate().onDetach();
    }

    public void onStop() {
        super.onStop();
        this.getMvpDelegate().onDetach();
    }

    public void onDestroyView() {
        super.onDestroyView();
        this.getMvpDelegate().onDetach();
        this.getMvpDelegate().onDestroyView();
    }

    public void onDestroy() {
        super.onDestroy();
        if (this.getActivity().isFinishing()) {
            this.getMvpDelegate().onDestroy();
            return;
        }
        if (this.mIsStateSaved) {
            this.mIsStateSaved = false;
            return;
        }
        boolean anyParentIsRemoving = false;
        if (Build.VERSION.SDK_INT >= 17) {
            for (Fragment parent = this.getParentFragment(); !anyParentIsRemoving && parent != null; parent = parent.getParentFragment()) {
                anyParentIsRemoving = parent.isRemoving();
            }
        }
        if (this.isRemoving() || anyParentIsRemoving) {
            this.getMvpDelegate().onDestroy();
        }
    }

    public MvpDelegate getMvpDelegate() {
        if (this.mMvpDelegate == null) {
            this.mMvpDelegate = new MvpDelegate((Object)this);
        }
        return this.mMvpDelegate;
    }
}

