/*
 * Decompiled with CFR 0.152.
 */
package tech.rsqn.search.lucene;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.SortedNumericDocValuesField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.spans.SpanNearQuery;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.search.spans.SpanTermQuery;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.rsqn.search.proxy.Attribute;
import tech.rsqn.search.proxy.Index;
import tech.rsqn.search.proxy.IndexAttribute;
import tech.rsqn.search.proxy.IndexEntry;
import tech.rsqn.search.proxy.IndexMetrics;
import tech.rsqn.search.proxy.SearchAttribute;
import tech.rsqn.search.proxy.SearchQuery;
import tech.rsqn.search.proxy.SearchResult;
import tech.rsqn.search.proxy.SearchResultItem;

public class LuceneIndex
implements Index {
    public static final String ID_FIELD = "id";
    public static final String REFERENCE_FIELD = "reference";
    private static Logger log = LoggerFactory.getLogger(LuceneIndex.class);
    private List<String> wildCardFields;
    private String indexPath;
    private boolean createOnly;
    private AtomicBoolean withinBatch = new AtomicBoolean(false);
    private Directory indexDir;
    private Analyzer indexWriterAnalyzer = new StandardAnalyzer();
    private IndexWriterConfig iwc;
    private IndexWriter writer;
    private long lastUpdate = 0L;
    private long lastRead = 0L;

    public LuceneIndex() {
        this.wildCardFields = new ArrayList<String>();
    }

    public IndexMetrics fetchMetrics() {
        IndexMetrics ret = new IndexMetrics();
        ret.put("withinBatch", (Object)this.withinBatch);
        ret.put("lastUpdate", (Object)new Date(this.lastUpdate));
        ret.put("lastRead", (Object)new Date(this.lastRead));
        try {
            DirectoryReader reader = DirectoryReader.open((Directory)FSDirectory.open((Path)Paths.get(this.indexPath, new String[0])));
            ret.put("size", (Object)reader.numDocs());
        }
        catch (IOException e) {
            log.warn(e.getMessage(), (Throwable)e);
            ret.put("error", (Object)e.getMessage());
        }
        return ret;
    }

    public void setWildCardFields(List<String> wildCardFields) {
        this.wildCardFields = wildCardFields;
    }

    public void setIndexPath(String indexPath) {
        this.indexPath = indexPath;
    }

    public void setCreateOnly(boolean createOnly) {
        this.createOnly = createOnly;
    }

    public void clearIndex() {
        this.createOnly = true;
    }

    private void mayRead() {
        if (this.withinBatch.get()) {
            throw new RuntimeException("Index is currently being updated in batch mode");
        }
    }

    private void mayWrite() {
        if (!this.withinBatch.get()) {
            throw new RuntimeException("This index requires batch mode to be active for writes-batch entry has not been started");
        }
    }

    public synchronized void submitSingleEntry(IndexEntry entry) {
        this.beginBatch();
        this.submitBatchEntry(entry);
        this.endBatch();
    }

    public void submitBatchEntry(IndexEntry entry) {
        this.mayWrite();
        this.lastUpdate = System.currentTimeMillis();
        Document doc = new Document();
        for (String keyField : entry.getAttrs().keySet()) {
            StringField f;
            String s;
            IndexAttribute v = (IndexAttribute)entry.getAttrs().get(keyField);
            if (v == null || v.getAttrValue() == null) continue;
            if (Attribute.Type.String == v.getAttrType()) {
                s = (String)v.getAttrValueAs(String.class);
                f = new StringField(keyField, s, Field.Store.YES);
                doc.add((IndexableField)f);
                continue;
            }
            if (Attribute.Type.Text == v.getAttrType()) {
                s = (String)v.getAttrValueAs(String.class);
                f = new TextField(keyField, s, Field.Store.NO);
                doc.add((IndexableField)f);
                continue;
            }
            if (Attribute.Type.Long == v.getAttrType()) {
                Long n = (Long)v.getAttrValueAs(Long.class);
                f = new SortedNumericDocValuesField(keyField, n.longValue());
                doc.add((IndexableField)f);
                continue;
            }
            log.warn("Unsupported attribute type " + v.getAttrType());
        }
        try {
            if (this.writer.getConfig().getOpenMode() == IndexWriterConfig.OpenMode.CREATE) {
                this.writer.addDocument((Iterable)doc);
                log.debug("added " + entry);
            } else {
                this.writer.updateDocument(new Term(REFERENCE_FIELD, entry.getReference()), (Iterable)doc);
                log.debug("updated " + entry);
            }
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    public void beginBatch() {
        if (this.withinBatch.get()) {
            throw new RuntimeException("already within batch update");
        }
        log.info("beginBatch");
        try {
            this.indexDir = FSDirectory.open((Path)Paths.get(this.indexPath, new String[0]));
            this.iwc = new IndexWriterConfig(this.indexWriterAnalyzer);
            if (this.createOnly) {
                this.iwc.setOpenMode(IndexWriterConfig.OpenMode.CREATE);
            } else {
                this.iwc.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
            }
            this.iwc.setRAMBufferSizeMB(64.0);
            this.writer = new IndexWriter(this.indexDir, this.iwc);
            this.withinBatch.set(true);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void endBatch() {
        log.info("endBatch");
        if (!this.withinBatch.get()) {
            throw new RuntimeException("no batch update in progress");
        }
        try {
            this.withinBatch.set(false);
            this.writer.commit();
            this.writer.close();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public SearchResult search(String s, int max) {
        SearchQuery q = new SearchQuery().with("*", (Object)s).limit(max);
        return this.search(q);
    }

    private IndexEntry docToIndexEntry(ScoreDoc hit, Document doc) {
        IndexEntry ret = new IndexEntry();
        ret.setUid(doc.get(ID_FIELD));
        ret.setReference(doc.get(REFERENCE_FIELD));
        for (IndexableField indexableField : doc.getFields()) {
            ret.addAttr(indexableField.name(), indexableField.stringValue());
        }
        return ret;
    }

    private Query searchQueryToLuceneQuery(SearchQuery query) {
        BooleanQuery luceneQuery = null;
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        for (SearchAttribute searchAttribute : query.getAttributes()) {
            Query _q;
            if ("*".equals(searchAttribute.getName())) {
                for (String wildCardField : this.wildCardFields) {
                    _q = this.searchAttributeToLuceneQuery(new SearchAttribute().with(wildCardField, searchAttribute.getPattern()));
                    builder.add(_q, BooleanClause.Occur.SHOULD);
                }
                continue;
            }
            _q = this.searchAttributeToLuceneQuery(searchAttribute);
            builder.add(_q, BooleanClause.Occur.SHOULD);
        }
        luceneQuery = builder.build();
        return luceneQuery;
    }

    private Query searchAttributeToLuceneQuery(SearchAttribute attr) {
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        if (SearchAttribute.Type.FUZZY == attr.getMatchType()) {
            FuzzyQuery _q = new FuzzyQuery(new Term(attr.getName(), attr.getPattern().toString()));
            builder.add((Query)_q, BooleanClause.Occur.SHOULD);
            String[] parts = attr.getPattern().toString().split(" ");
            if (parts.length > 1) {
                SpanQuery[] spq = new SpanQuery[parts.length];
                for (int i = 0; i < parts.length; ++i) {
                    _q = new SpanTermQuery(new Term(attr.getName(), parts[i]));
                    spq[i] = (SpanQuery)_q;
                }
                SpanNearQuery spanNear1 = new SpanNearQuery(spq, 10, true);
                builder.add((Query)spanNear1, BooleanClause.Occur.SHOULD);
            }
        } else if (SearchAttribute.Type.EQ == attr.getMatchType()) {
            TermQuery _q = new TermQuery(new Term(attr.getName(), attr.getPattern().toString()));
            builder.add((Query)_q, BooleanClause.Occur.SHOULD);
        } else {
            throw new RuntimeException("Unsupported search attribute type");
        }
        BooleanQuery ret = builder.build();
        return ret;
    }

    public SearchResult search(SearchQuery proxyQuery) {
        this.mayRead();
        this.lastRead = System.currentTimeMillis();
        SearchResult ret = new SearchResult();
        DirectoryReader reader = null;
        IndexSearcher searcher = null;
        try {
            reader = DirectoryReader.open((Directory)FSDirectory.open((Path)Paths.get(this.indexPath, new String[0])));
            searcher = new IndexSearcher((IndexReader)reader);
            Query luceneQuery = this.searchQueryToLuceneQuery(proxyQuery);
            Sort sort = null;
            for (SearchAttribute searchAttribute : proxyQuery.getAttributes()) {
                SortField startField = new SortField(searchAttribute.getName(), SortField.Type.DOC);
                SortField scoreField = SortField.FIELD_SCORE;
                sort = new Sort(new SortField[]{scoreField, startField});
            }
            Object results = sort != null ? searcher.search(luceneQuery, proxyQuery.getLimit(), sort) : searcher.search(luceneQuery, proxyQuery.getLimit());
            ScoreDoc[] hits = results.scoreDocs;
            int numTotalHits = results.totalHits;
            log.debug(numTotalHits + " total matching documents");
            for (ScoreDoc hit : hits) {
                log.debug("doc=" + hit.doc + " score=" + hit.score);
                Document doc = searcher.doc(hit.doc);
                String id = doc.get(ID_FIELD);
                log.debug("doc=" + hit.doc + " score=" + hit.score + " id=" + id);
                SearchResultItem item = new SearchResultItem().with(this.docToIndexEntry(hit, doc), (double)hit.score);
                ret.addMatch(item);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {
                log.warn(e.getMessage(), (Throwable)e);
            }
        }
        return ret;
    }
}

