/*
 * Decompiled with CFR 0.152.
 */
package tech.rsqn.useful.things.lambda;

import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.RequestHandler;
import com.amazonaws.services.lambda.runtime.events.APIGatewayProxyRequestEvent;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.util.ISO8601DateFormat;
import java.io.IOException;
import java.text.DateFormat;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;
import tech.rsqn.useful.things.lambda.LambdaSpringUtil;

public abstract class AbstractLambdaSpringService<C, R>
implements RequestHandler<APIGatewayProxyRequestEvent, R> {
    private static final Logger LOG = Logger.getLogger(AbstractLambdaSpringService.class);

    public AbstractLambdaSpringService() {
        BasicConfigurator.configure();
    }

    protected void wire(Object o) {
        LambdaSpringUtil.wireInSpring(o, o.getClass().getSimpleName());
    }

    public abstract R handleRequest(APIGatewayProxyRequestEvent var1, C var2, Context var3);

    public abstract Class getModelClass();

    public R handleRequest(APIGatewayProxyRequestEvent proxyEvent, Context context) {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        objectMapper.setDateFormat((DateFormat)new ISO8601DateFormat());
        Object model = null;
        try {
            LOG.debug((Object)("ProxyRequest " + proxyEvent.toString()));
            if (proxyEvent.getHeaders() == null && proxyEvent.getHttpMethod() == null) {
                LOG.debug((Object)"v2 This seems to be a keepalive. returning");
                return null;
            }
            if (proxyEvent.getBody() != null && proxyEvent.getBody().length() > 0) {
                model = objectMapper.readValue(proxyEvent.getBody(), this.getModelClass());
            }
            return this.handleRequest(proxyEvent, model, context);
        }
        catch (IOException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

