/*
 * Decompiled with CFR 0.152.
 */
package tech.rsqn.useful.things.lambda;

import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBClientBuilder;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapper;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Component;
import tech.rsqn.useful.things.lambda.AbstractLambdaSpringService;

@Component
public abstract class AbstractLambdaDynamoService<C, R>
extends AbstractLambdaSpringService<C, R> {
    private static final Logger LOG = Logger.getLogger(AbstractLambdaDynamoService.class);
    protected AmazonDynamoDB dynamodb = null;
    protected DynamoDBMapper mapper = null;
    private String region = System.getProperty("dynamo.region");
    private String endpoint = System.getProperty("dynamo.endpoint");

    public AbstractLambdaDynamoService() {
        Regions r = Regions.AP_SOUTHEAST_2;
        if (this.region != null && this.region.length() > 0) {
            r = Regions.fromName((String)this.region);
        }
        this.dynamodb = this.endpoint != null && this.endpoint.length() > 0 ? (AmazonDynamoDB)((AmazonDynamoDBClientBuilder)AmazonDynamoDBClientBuilder.standard().withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(this.endpoint, r.getName()))).build() : (AmazonDynamoDB)((AmazonDynamoDBClientBuilder)AmazonDynamoDBClientBuilder.standard().withRegion(r)).build();
        this.mapper = new DynamoDBMapper(this.dynamodb);
    }
}

