/*
 * Decompiled with CFR 0.152.
 */
package tech.rsqn.useful.things.lambda;

import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDB;
import com.amazonaws.services.dynamodbv2.AmazonDynamoDBClientBuilder;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapper;
import com.amazonaws.services.dynamodbv2.datamodeling.DynamoDBMapperConfig;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Component;

@Component
public abstract class AbstractDynamoBackedService {
    private static final Logger LOG = Logger.getLogger(AbstractDynamoBackedService.class);
    protected AmazonDynamoDB dynamodb = null;
    protected DynamoDBMapper mapper = null;
    protected DynamoDBMapperConfig mapperConfig;
    private String region = System.getProperty("dynamo.region");
    private String endpoint = System.getProperty("dynamo.endpoint");

    public AbstractDynamoBackedService() {
        Regions r = Regions.AP_SOUTHEAST_2;
        if (this.region != null && this.region.length() > 0) {
            r = Regions.fromName((String)this.region);
        }
        this.mapperConfig = DynamoDBMapperConfig.DEFAULT;
        this.dynamodb = this.endpoint != null && this.endpoint.length() > 0 ? (AmazonDynamoDB)((AmazonDynamoDBClientBuilder)AmazonDynamoDBClientBuilder.standard().withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(this.endpoint, r.getName()))).build() : (AmazonDynamoDB)((AmazonDynamoDBClientBuilder)AmazonDynamoDBClientBuilder.standard().withRegion(r)).build();
        this.mapper = new DynamoDBMapper(this.dynamodb);
    }
}

