/*
 * Decompiled with CFR 0.152.
 */
package tech.rsqn.useful.things.encryption;

import java.io.FileReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.spec.RSAPublicKeySpec;
import javax.crypto.Cipher;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;
import org.bouncycastle.util.encoders.Base64;
import tech.rsqn.useful.things.encryption.EncryptionTool;

public class RSAEncryptionTool
implements EncryptionTool {
    private String charSet = "utf-8";
    private String keyPassword;
    private String keyFile;
    private String algorithm = "RSA/NONE/OAEPPadding";
    private String provider = "BC";
    private static final String CLASS_PATH_PREFIX = "classpath:";

    public String getKeyFile() {
        return this.keyFile;
    }

    public void setKeyFile(String keyFile) {
        this.keyFile = keyFile;
    }

    public String getKeyPassword() {
        return this.keyPassword;
    }

    public void setKeyPassword(String keyPassword) {
        this.keyPassword = keyPassword;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public RSAEncryptionTool() {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    @Override
    public byte[] encrypt(byte[] plainText) {
        try {
            PublicKey publicKey = this.extractPublicKeyFromPrivateKeyFile();
            Cipher cipher = Cipher.getInstance(this.algorithm, this.provider);
            cipher.init(1, publicKey);
            return cipher.doFinal(plainText);
        }
        catch (Exception e) {
            throw new RuntimeException("Decryption exception " + e, e);
        }
    }

    @Override
    public byte[] decrypt(byte[] cryptText) {
        try {
            PrivateKey privateKey = this.readPrivateKeyFile();
            Cipher cipher = Cipher.getInstance(this.algorithm, this.provider);
            cipher.init(2, privateKey);
            return cipher.doFinal(cryptText);
        }
        catch (Exception e) {
            throw new RuntimeException("Encryption exception " + e, e);
        }
    }

    @Override
    public String encode(String plainText) {
        try {
            byte[] encData = this.encrypt(plainText.getBytes(this.charSet));
            return new String(Base64.toBase64String((byte[])encData));
        }
        catch (Exception e) {
            throw new RuntimeException("Encryption exception " + e, e);
        }
    }

    @Override
    public String decode(String encodedText) {
        try {
            byte[] encData = Base64.decode((String)encodedText);
            byte[] decData = this.decrypt(encData);
            return new String(decData, this.charSet);
        }
        catch (Exception e) {
            throw new RuntimeException("Decryption exception " + e, e);
        }
    }

    @Override
    public void setCharSet(String charSet) {
        this.charSet = charSet;
    }

    private PublicKey extractPublicKeyFromPrivateKeyFile() throws Exception {
        PrivateKey privateKey = this.readPrivateKeyFile();
        RSAPrivateCrtKey rsaPrivateCrtKey = (RSAPrivateCrtKey)privateKey;
        RSAPublicKeySpec publicKeySpec = new RSAPublicKeySpec(rsaPrivateCrtKey.getModulus(), rsaPrivateCrtKey.getPublicExponent());
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        return keyFactory.generatePublic(publicKeySpec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PrivateKey readPrivateKeyFile() throws Exception {
        JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider(this.provider);
        PrivateKey privateKey = null;
        try (Reader keyReader = null;){
            if (this.keyFile.startsWith(CLASS_PATH_PREFIX)) {
                String keyResource = this.keyFile.substring(CLASS_PATH_PREFIX.length());
                keyReader = new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream(keyResource));
            } else {
                keyReader = new FileReader(this.keyFile);
            }
            PEMParser pemParser = new PEMParser(keyReader);
            Object key = pemParser.readObject();
            if (key instanceof PEMEncryptedKeyPair) {
                PEMDecryptorProvider decryptionProvider = new JcePEMDecryptorProviderBuilder().build(this.keyPassword.toCharArray());
                privateKey = converter.getKeyPair(((PEMEncryptedKeyPair)key).decryptKeyPair(decryptionProvider)).getPrivate();
            } else {
                privateKey = converter.getKeyPair((PEMKeyPair)key).getPrivate();
            }
        }
        return privateKey;
    }
}

