/*
 * Decompiled with CFR 0.152.
 */
package tech.rsqn.useful.things.encryption;

import java.security.Key;
import java.security.Provider;
import java.security.Security;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Base64;
import tech.rsqn.useful.things.encryption.EncryptionTool;

public class AESEncryptionTool
implements EncryptionTool {
    private String charSet = "utf-8";
    private byte[] key;
    private int blockSize = 16;
    private String alorithm = "AES/CBC/PKCS5Padding";
    private String provider = "BC";

    @Override
    public void setCharSet(String charSet) {
        this.charSet = charSet;
    }

    public AESEncryptionTool() {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    public void setKey(byte[] keyBytes) {
        this.key = keyBytes;
    }

    private byte[] getRandomBytes(int n) {
        byte[] ret = new byte[n];
        new Random().nextBytes(ret);
        return ret;
    }

    @Override
    public byte[] encrypt(byte[] plainText) {
        try {
            Cipher enCipher = Cipher.getInstance(this.alorithm, this.provider);
            byte[] iv = this.getRandomBytes(this.blockSize);
            enCipher.init(1, (Key)new SecretKeySpec(this.key, "AES"), new IvParameterSpec(iv));
            byte[] encrypted = enCipher.doFinal(plainText);
            byte[] ret = new byte[iv.length + encrypted.length];
            System.arraycopy(iv, 0, ret, 0, iv.length);
            System.arraycopy(encrypted, 0, ret, iv.length, encrypted.length);
            return ret;
        }
        catch (Exception e) {
            throw new RuntimeException("Encryption exception " + e, e);
        }
    }

    @Override
    public byte[] decrypt(byte[] cryptText) {
        try {
            Cipher deCipher = Cipher.getInstance(this.alorithm, this.provider);
            byte[] iv = new byte[this.blockSize];
            byte[] decData = new byte[cryptText.length - this.blockSize];
            System.arraycopy(cryptText, 0, iv, 0, iv.length);
            System.arraycopy(cryptText, iv.length, decData, 0, decData.length);
            deCipher.init(2, (Key)new SecretKeySpec(this.key, "AES"), new IvParameterSpec(iv));
            return deCipher.doFinal(decData);
        }
        catch (Exception e) {
            throw new RuntimeException("Encryption exception " + e, e);
        }
    }

    @Override
    public String encode(String plainText) {
        try {
            byte[] encData = this.encrypt(plainText.getBytes(this.charSet));
            String encString = Base64.toBase64String((byte[])encData);
            return encString;
        }
        catch (Exception e) {
            throw new RuntimeException("Encryption exception " + e, e);
        }
    }

    @Override
    public String decode(String encodedText) {
        try {
            byte[] de = Base64.decode((String)encodedText);
            byte[] decData = this.decrypt(de);
            return new String(decData, this.charSet);
        }
        catch (Exception e) {
            throw new RuntimeException("Decryption exception " + e, e);
        }
    }
}

