/*
 * Decompiled with CFR 0.152.
 */
package tech.rsqn.cacheservice.util;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupTimer {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    Map<String, Timer> timers = new HashMap<String, Timer>();

    private void log(String s) {
        this.log.info(s);
    }

    public void start(String name) {
        this.log("Start " + name);
        Timer timer = this.timers.get(name);
        if (timer == null) {
            timer = new Timer();
            timer.name = name;
            this.timers.put(name, timer);
        }
        timer.start();
    }

    public void stop(String name) {
        Timer timer = this.timers.get(name);
        if (timer == null) {
            return;
        }
        timer.stop();
    }

    public void stopAndReport(String name) {
        Timer timer = this.timers.get(name);
        if (timer == null) {
            return;
        }
        timer.stop();
        this.log(timer.report());
    }

    public void report(String name) {
        Timer timer = this.timers.get(name);
        if (timer == null) {
            return;
        }
        this.log(timer.report());
    }

    class Timer {
        String name;
        long startTime;
        long endTime;
        long totalTime = 0L;
        long executions = 0L;
        long min = -1L;
        long max = -1L;

        Timer() {
        }

        public void start() {
            this.startTime = System.currentTimeMillis();
        }

        public void stop() {
            this.endTime = System.currentTimeMillis();
            this.totalTime += this.endTime - this.startTime;
            long diff = this.endTime - this.startTime;
            if (diff < this.min || this.min == -1L) {
                this.min = diff;
            }
            if (diff > this.max || this.max == -1L) {
                this.max = diff;
            }
            ++this.executions;
        }

        private String fmt(long l) {
            if (l > 1000L) {
                float v = l / 1000L;
                return v + "s";
            }
            return l + "ms";
        }

        private String fmt(float l) {
            if (l > 1000.0f) {
                float v = l / 1000.0f;
                return v + "s";
            }
            return l + "ms";
        }

        public String report() {
            String ret = "";
            long taken = this.endTime - this.startTime;
            ret = ret + this.name + " " + this.fmt(taken);
            ret = ret + " total " + this.fmt(this.totalTime) + " for " + this.executions + " executions";
            if (this.executions > 0L) {
                float avg = this.totalTime / this.executions;
                ret = ret + " avg " + this.fmt(avg);
            }
            if (this.executions > 0L) {
                ret = ret + " min " + this.fmt(this.min);
                ret = ret + " max " + this.fmt(this.max);
            }
            return ret;
        }
    }
}

