/*
 * Decompiled with CFR 0.152.
 */
package tech.rsqn.cacheservice.support;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.rsqn.cacheservice.support.CacheBehaviour;

public class TransparentCacheExecutionBehaviour {
    private static Logger log = LoggerFactory.getLogger(TransparentCacheExecutionBehaviour.class);
    public static final ThreadLocal<CacheBehaviour> threadLocal = new ThreadLocal();

    public static CacheBehaviour getBehaviour() {
        CacheBehaviour cb = threadLocal.get();
        if (cb == null) {
            cb = new CacheBehaviour();
            threadLocal.set(cb);
        }
        return cb;
    }

    public static void clearCacheAfterReads() {
        log.info("Changing cache behaviour to clearCacheAfterReads");
        TransparentCacheExecutionBehaviour.getBehaviour().clearCacheAfterRead();
    }

    public static void returnIfItemIsNotCached() {
        log.info("Changing cache behaviour to returnIfItemIsNotCached");
        TransparentCacheExecutionBehaviour.getBehaviour().returnIfItemIsNotCached();
    }

    public static void enableDefaultBehaviour() {
        log.info("Changing cache behaviour to enableDefaultBehaviour");
        TransparentCacheExecutionBehaviour.getBehaviour().enableDefaultBehaviour();
    }
}

