/*
 * Decompiled with CFR 0.152.
 */
package tech.rsqn.cacheservice.support;

import java.io.Serializable;
import tech.rsqn.cacheservice.support.CacheEntryValue;

public class DefaultCacheEntryValue
implements CacheEntryValue,
Serializable {
    private String key;
    private Object value;
    private long inserted;
    private long timeToLiveSeconds;

    public static <T extends Serializable> DefaultCacheEntryValue with(String key, Object v) {
        DefaultCacheEntryValue ret = new DefaultCacheEntryValue();
        ret.key = key;
        ret.value = v;
        return ret;
    }

    public DefaultCacheEntryValue andTimeToLiveSeconds(long ttl) {
        this.timeToLiveSeconds = ttl;
        this.inserted = System.currentTimeMillis();
        return this;
    }

    public String getKey() {
        return this.key;
    }

    public boolean isValid() {
        if (this.timeToLiveSeconds > 0L) {
            return System.currentTimeMillis() < this.inserted + this.timeToLiveSeconds * 1000L;
        }
        return true;
    }

    @Override
    public <T> void setValue(T value) {
        this.value = value;
    }

    @Override
    public final <T> T getValue() {
        return (T)this.value;
    }

    public long getInserted() {
        return this.inserted;
    }

    public void setInserted(long inserted) {
        this.inserted = inserted;
    }

    public long getTimeToLiveSeconds() {
        return this.timeToLiveSeconds;
    }

    public void setTimeToLiveSeconds(long timeToLiveSeconds) {
        this.timeToLiveSeconds = timeToLiveSeconds;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultCacheEntryValue that = (DefaultCacheEntryValue)o;
        return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
    }

    public final int hashCode() {
        return this.value != null ? this.value.hashCode() : 0;
    }
}

