/*
 * Decompiled with CFR 0.152.
 */
package tech.rsqn.cacheservice.referencetransparentcache;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.ParserContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.util.ReflectionUtils;
import tech.rsqn.cacheservice.CacheService;
import tech.rsqn.cacheservice.TransparentCacheService;
import tech.rsqn.cacheservice.annotations.CacheKey;
import tech.rsqn.cacheservice.annotations.ReadOperation;
import tech.rsqn.cacheservice.exceptions.CacheReflectionRuntimeException;
import tech.rsqn.cacheservice.interceptors.InterceptorMetadata;
import tech.rsqn.cacheservice.interceptors.InterceptorUtil;
import tech.rsqn.cacheservice.support.CacheKeyGenerator;
import tech.rsqn.cacheservice.support.NonSerializableWrapper;
import tech.rsqn.cacheservice.support.ParameterKeyGenerator;
import tech.rsqn.cacheservice.support.ReadOperationUnlessKludge;
import tech.rsqn.cacheservice.support.TemplatedParserContext;
import tech.rsqn.cacheservice.support.TransparentCacheExecutionBehaviour;
import tech.rsqn.cacheservice.util.GroupTimer;
import tech.rsqn.reflectionhelpers.ReflectionHelper;

public class DefaultTransparentCacheService
implements TransparentCacheService {
    private boolean debugLogging = false;
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private String defaultCacheName = "default";
    private Map<String, CacheService> caches;
    private List<CacheKeyGenerator> keyGenerators;
    private List<ParameterKeyGenerator> parameterKeyGenerators;
    private boolean cachingDisabled = false;
    private ParameterNameDiscoverer parameterNameDiscoverer = new LocalVariableTableParameterNameDiscoverer();
    private ExpressionParser expressionParser = new SpelExpressionParser();
    private boolean supportParameterNameDiscovery = false;
    private GroupTimer groupTimer = new GroupTimer();

    @Required
    public void setCaches(Map<String, CacheService> caches) {
        this.caches = caches;
    }

    @Override
    public Map<String, CacheService> getCaches() {
        return this.caches;
    }

    public void setSupportParameterNameDiscovery(boolean supportParameterNameDiscovery) {
        this.supportParameterNameDiscovery = supportParameterNameDiscovery;
    }

    public void disableCaching() {
        this.cachingDisabled = true;
    }

    public void enableCaching() {
        this.cachingDisabled = true;
    }

    @Required
    public void setDefaultCacheName(String defaultCacheName) {
        this.defaultCacheName = defaultCacheName;
    }

    public void setDebugLogging(boolean debugLogging) {
        this.debugLogging = debugLogging;
    }

    @Required
    public void setKeyGenerators(List<CacheKeyGenerator> keyGenerators) {
        this.keyGenerators = keyGenerators;
    }

    @Required
    public void setParameterKeyGenerators(List<ParameterKeyGenerator> parameterKeyGenerators) {
        this.parameterKeyGenerators = parameterKeyGenerators;
    }

    @Override
    public long count() {
        long ret = 0L;
        for (CacheService cache : this.caches.values()) {
            ret += cache.count();
        }
        return ret;
    }

    @Override
    public long clear() {
        long ret = 0L;
        for (CacheService cache : this.caches.values()) {
            ret += cache.clear();
        }
        return ret;
    }

    @Override
    public List<Class> getSupportedTypes() {
        ArrayList<Class> ret = new ArrayList<Class>();
        for (CacheKeyGenerator keyGenerator : this.keyGenerators) {
            ret.addAll(keyGenerator.getSupportedClasses());
        }
        return ret;
    }

    @Override
    public String generateParameterKey(Object parameter) {
        String key = null;
        for (ParameterKeyGenerator generator : this.parameterKeyGenerators) {
            if (parameter == null || !generator.supportsClass(parameter.getClass()) || (key = generator.generateParamKey(parameter)) == null) continue;
            return key;
        }
        return null;
    }

    @Override
    public String generateCacheKey(Class clazz, Object ... arguments) {
        String key = null;
        for (CacheKeyGenerator keyGenerator : this.keyGenerators) {
            if (!keyGenerator.supportsClass(clazz) || (key = keyGenerator.generateKey(this, clazz, arguments)) == null) continue;
            return key;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String generateKeyFromCacheKeyAnnotation(MethodInvocation invocation, CacheKey cacheKeyAnnotation) {
        if (cacheKeyAnnotation.generator() != Object.class) {
            try {
                CacheKeyGenerator generator = (CacheKeyGenerator)cacheKeyAnnotation.generator().newInstance();
                if (invocation.getArguments() == null || invocation.getArguments().length <= 0) return null;
                for (Object o : invocation.getArguments()) {
                    String cacheKey;
                    if (o == null || !generator.supportsEntity(o) || (cacheKey = generator.generateKey(o)) == null) continue;
                    return cacheKey;
                }
                return null;
            }
            catch (InstantiationException e) {
                throw new CacheReflectionRuntimeException("Exception using Cache Key Generator " + cacheKeyAnnotation.generator(), e);
            }
            catch (IllegalAccessException e) {
                throw new CacheReflectionRuntimeException("Exception using Cache Key Generator " + cacheKeyAnnotation.generator(), e);
            }
        } else {
            if (cacheKeyAnnotation.template() == null || cacheKeyAnnotation.template().length() <= 0) return null;
            return this.generateCacheKeyFromTemplate(invocation, cacheKeyAnnotation.template());
        }
    }

    public String generateCacheKeyFromTemplate(MethodInvocation mi, String keyTemplate) {
        int i;
        Method method = ReflectionUtils.findMethod(mi.getThis().getClass(), (String)mi.getMethod().getName(), (Class[])mi.getMethod().getParameterTypes());
        StandardEvaluationContext context = new StandardEvaluationContext();
        Object[] arguments = mi.getArguments();
        String[] parameterNames = this.parameterNameDiscoverer.getParameterNames(method);
        if (parameterNames != null) {
            for (i = 0; i < parameterNames.length; ++i) {
                context.setVariable(parameterNames[i], arguments[i]);
            }
        }
        for (i = 0; i < arguments.length; ++i) {
            context.setVariable("arg" + i, arguments[i]);
        }
        Expression expression = this.expressionParser.parseExpression(keyTemplate, (ParserContext)new TemplatedParserContext());
        return (String)expression.getValue((EvaluationContext)context, String.class);
    }

    @Override
    public <T extends Serializable> String generateCacheKey(T entity) {
        String key = null;
        for (CacheKeyGenerator keyGenerator : this.keyGenerators) {
            if (!keyGenerator.supportsEntity(entity) || (key = keyGenerator.generateKey(entity)) == null) continue;
            return key;
        }
        return null;
    }

    @Override
    public Object aroundWriteMethodInvocation(MethodInvocation invocation, InterceptorMetadata meta) throws Throwable {
        this.groupTimer.start("aroundWriteMethodInvocation");
        Object[] args = invocation.getArguments();
        Method targetMethod = invocation.getMethod();
        Class<?> returnType = targetMethod.getReturnType();
        CacheService cache = this.resolveCacheService(meta);
        if (this.debugLogging) {
            this.log.debug(MessageFormat.format("Write Interceptor called for {0}.{1} with return type {2} and {3} arguments", targetMethod.getDeclaringClass(), targetMethod.getName(), returnType.getName(), args.length));
        }
        CacheKey cacheKeyAnnotation = (CacheKey)ReflectionHelper.getAnnotationFromInvocation((MethodInvocation)invocation, CacheKey.class);
        String cacheKey = null;
        if (cacheKeyAnnotation != null) {
            cacheKey = this.generateKeyFromCacheKeyAnnotation(invocation, cacheKeyAnnotation);
        }
        if (cacheKey != null) {
            this.log.debug("Write Interceptor invalidating key (" + cacheKey + ")");
            cache.remove(cacheKey);
        }
        this.groupTimer.stopAndReport("aroundWriteMethodInvocation");
        Object returnValue = invocation.proceed();
        return returnValue;
    }

    @Override
    public Object aroundReadMethodInvocation(MethodInvocation invocation, InterceptorMetadata meta) throws Throwable {
        ReadOperationUnlessKludge kludge;
        NonSerializableWrapper wrapper;
        Object cachedValue;
        this.groupTimer.start("aroundReadMethodInvocation-READ");
        Object[] args = invocation.getArguments();
        Method targetMethod = invocation.getMethod();
        Class<?> returnType = targetMethod.getReturnType();
        CacheService cache = this.resolveCacheService(meta);
        if (this.cachingDisabled) {
            this.log.debug("caching is disabled - executing method ");
            this.groupTimer.stopAndReport("aroundReadMethodInvocation-READ");
            return invocation.proceed();
        }
        if (this.debugLogging) {
            this.log.debug(MessageFormat.format("Read Interceptor called for {0}.{1} with return type {2} and {3} arguments", targetMethod.getDeclaringClass().getName(), targetMethod.getName(), returnType.getName(), args.length));
        }
        CacheKey cacheKeyAnnotation = (CacheKey)ReflectionHelper.getAnnotationFromInvocation((MethodInvocation)invocation, CacheKey.class);
        ReadOperation readOperation = (ReadOperation)ReflectionHelper.getAnnotationFromInvocation((MethodInvocation)invocation, ReadOperation.class);
        String entityCacheKey = null;
        String methodCacheKey = null;
        entityCacheKey = cacheKeyAnnotation != null && args.length > 0 ? this.generateKeyFromCacheKeyAnnotation(invocation, cacheKeyAnnotation) : this.generateCacheKey(returnType, args);
        if (entityCacheKey == null) {
            methodCacheKey = InterceptorUtil.generateCacheKeyBasedOnMethodInvocation(this, invocation);
        }
        if (this.debugLogging) {
            this.log.debug(MessageFormat.format("Read Interceptor entityCacheKey ({0}) , methodCacheKey ({1}) ", entityCacheKey, methodCacheKey));
        }
        if (entityCacheKey != null) {
            cachedValue = null;
            if (cache.containsKey(entityCacheKey)) {
                cachedValue = cache.get(entityCacheKey);
            }
            if (cachedValue != null) {
                if (this.debugLogging) {
                    this.log.debug("Read Interceptor will return item from cache  (" + entityCacheKey + ")");
                }
                if (TransparentCacheExecutionBehaviour.getBehaviour().isClearCacheAfterRead()) {
                    this.log.debug("Read Interceptor Clearing cache entity key  (" + entityCacheKey + ") based on " + TransparentCacheExecutionBehaviour.getBehaviour());
                    cache.remove(entityCacheKey);
                }
                if (cachedValue instanceof NonSerializableWrapper) {
                    wrapper = cachedValue;
                    if (wrapper.getValue() != null) {
                        this.groupTimer.stopAndReport("aroundReadMethodInvocation-READ");
                        return wrapper.getValue();
                    }
                } else {
                    this.groupTimer.stopAndReport("aroundReadMethodInvocation-READ");
                    return cachedValue;
                }
            }
            if (this.debugLogging) {
                this.log.debug("Read Interceptor not found in cache (" + entityCacheKey + ")");
            }
        }
        if (methodCacheKey != null && entityCacheKey == null) {
            cachedValue = null;
            if (cache.containsKey(methodCacheKey)) {
                cachedValue = cache.get(methodCacheKey);
            }
            if (cachedValue != null) {
                if (this.debugLogging) {
                    this.log.debug("Read Interceptor returning item from cache (" + methodCacheKey + ")");
                }
                if (TransparentCacheExecutionBehaviour.getBehaviour().isClearCacheAfterRead()) {
                    this.log.debug("Read Interceptor Clearing cache method key  (" + methodCacheKey + ") based on " + TransparentCacheExecutionBehaviour.getBehaviour());
                    cache.remove(methodCacheKey);
                }
                if (cachedValue instanceof NonSerializableWrapper) {
                    wrapper = cachedValue;
                    if (wrapper.getValue() != null) {
                        this.groupTimer.stopAndReport("aroundReadMethodInvocation-READ");
                        return wrapper.getValue();
                    }
                } else {
                    this.groupTimer.stopAndReport("aroundReadMethodInvocation-READ");
                    return cachedValue;
                }
            }
            if (this.debugLogging) {
                this.log.debug("Read Interceptor not found in cache (" + methodCacheKey + ")");
            }
        }
        if (TransparentCacheExecutionBehaviour.getBehaviour().isReturnIfItemIsNotCached()) {
            this.log.debug("Read Interceptor NOT proceeding with invocation (" + entityCacheKey + ") (" + methodCacheKey + ") based on " + TransparentCacheExecutionBehaviour.getBehaviour());
            this.groupTimer.stopAndReport("aroundReadMethodInvocation-READ");
            return null;
        }
        if (this.debugLogging) {
            this.log.debug("Read Interceptor proceeding with invocation (" + entityCacheKey + ") (" + methodCacheKey + ")");
        }
        this.groupTimer.stopAndReport("aroundReadMethodInvocation-READ");
        Object returnValue = invocation.proceed();
        Serializable cacheValue = null;
        this.groupTimer.start("aroundReadMethodInvocation-WRITE");
        if (readOperation != null && readOperation.unlessClass() != Object.class && returnValue != null && !(kludge = (ReadOperationUnlessKludge)readOperation.unlessClass().newInstance()).allowCaching(returnValue)) {
            this.log.info("ReadOperationUnlessKludge did not allow caching of(" + entityCacheKey + ") (" + methodCacheKey + ")");
            this.groupTimer.stopAndReport("aroundReadMethodInvocation-WRITE");
            return returnValue;
        }
        if (returnValue != null && !(returnValue instanceof Serializable)) {
            if (this.debugLogging) {
                this.log.debug("Return value is not serializable, wrapping in NonSerializableWrapper to cache in memory only (" + entityCacheKey + ") (" + methodCacheKey + ")");
            }
            cacheValue = NonSerializableWrapper.with(returnValue);
        } else if (returnValue instanceof Serializable) {
            cacheValue = (Serializable)returnValue;
        }
        if (cacheValue != null && entityCacheKey != null) {
            cache.put(entityCacheKey, cacheValue);
            if (this.debugLogging) {
                this.log.debug("Read Interceptor cached single entity (" + entityCacheKey + ")");
            }
        }
        if (methodCacheKey != null && entityCacheKey == null) {
            if (returnValue instanceof Collection) {
                if (this.debugLogging) {
                    this.log.debug("Read Interceptor cached collection under key (" + methodCacheKey + ")");
                }
                cache.put(methodCacheKey, cacheValue);
            } else if (returnValue instanceof Map) {
                if (this.debugLogging) {
                    this.log.debug("Read Interceptor cached map under key (" + methodCacheKey + ")");
                }
                cache.put(methodCacheKey, cacheValue);
            } else if (returnValue instanceof Object[]) {
                if (this.debugLogging) {
                    this.log.debug("Read Interceptor cached array under key (" + methodCacheKey + ")");
                }
                cache.put(methodCacheKey, cacheValue);
            } else {
                if (this.debugLogging) {
                    this.log.debug("Read Interceptor cached single object under method key (" + methodCacheKey + ")");
                }
                cache.put(methodCacheKey, cacheValue);
            }
        }
        this.groupTimer.stopAndReport("aroundReadMethodInvocation-WRITE");
        return returnValue;
    }

    @Override
    public Object aroundInvalidateMethodInvocation(MethodInvocation invocation, InterceptorMetadata meta) throws Throwable {
        this.groupTimer.start("aroundInvalidateMethodInvocation");
        Object[] args = invocation.getArguments();
        Method targetMethod = invocation.getMethod();
        Class<?> returnType = targetMethod.getReturnType();
        CacheService cache = this.resolveCacheService(meta);
        if (this.debugLogging) {
            this.log.debug(MessageFormat.format("Invalidating Interceptor called for {0}.{1} with return type {2} and {3} arguments", targetMethod.getDeclaringClass(), targetMethod.getName(), returnType.getName(), args.length));
        }
        CacheKey cacheKeyAnnotation = (CacheKey)ReflectionHelper.getAnnotationFromInvocation((MethodInvocation)invocation, CacheKey.class);
        int nRemoved = 0;
        String cacheKey = null;
        if (cacheKeyAnnotation != null) {
            cacheKey = this.generateKeyFromCacheKeyAnnotation(invocation, cacheKeyAnnotation);
        }
        if (cacheKey != null) {
            this.log.debug("Invalidating Interceptor invalidating key (" + cacheKey + ")");
            cache.remove(cacheKey);
            ++nRemoved;
        }
        if (cacheKeyAnnotation == null) {
            for (Object arg : args) {
                String cacheKeyFromArgs;
                if (!(arg instanceof Serializable) || (cacheKeyFromArgs = this.generateCacheKey((Serializable)arg)) == null) continue;
                this.log.debug("Invalidating Interceptor invalidating key (" + cacheKeyFromArgs + ")");
                cache.remove(cacheKeyFromArgs);
                ++nRemoved;
            }
        }
        String methodCacheKey = null;
        if (nRemoved == 0) {
            methodCacheKey = InterceptorUtil.generateCacheKeyBasedOnMethodInvocation(this, invocation);
        }
        if (methodCacheKey != null) {
            this.log.debug("Invalidating Interceptor invalidating key (" + methodCacheKey + ")");
            cache.remove(methodCacheKey);
        }
        this.groupTimer.stopAndReport("aroundInvalidateMethodInvocation");
        Object returnValue = invocation.proceed();
        return returnValue;
    }

    private CacheService resolveCacheService(InterceptorMetadata meta) {
        if (meta.getTarget() != null) {
            return this.caches.get(meta.getTarget());
        }
        return this.caches.get(this.defaultCacheName);
    }
}

