/*
 * Decompiled with CFR 0.152.
 */
package tech.rsqn.cacheservice.proxy;

import java.text.MessageFormat;
import tech.rsqn.cacheservice.exceptions.CacheConfigurationRuntimeException;
import tech.rsqn.cacheservice.interceptors.InterceptorMetadata;

public class CachingProxyConfigEntry {
    private static final String delimiter = ",";
    private String methodName;
    private InterceptorMetadata.Operation operation;
    private String target;

    public void parseFromString(String s) {
        try {
            String[] toks = s.trim().split(delimiter);
            if (toks.length != 3) {
                throw new CacheConfigurationRuntimeException(MessageFormat.format("Invalid Configuration {0}, configuration must follow the format METHODNAME(n/a),OPERATION(read/write/invalidate),TARGET(n/a)  ie   myMethod,read,myCache", s));
            }
            this.methodName = toks[0];
            this.operation = InterceptorMetadata.Operation.valueOf(toks[1]);
            this.target = toks[2];
            if (this.operation == null) {
                throw new CacheConfigurationRuntimeException(MessageFormat.format("Invalid Configuration {0}, configuration must follow the format METHODNAME(n/a),OPERATION(read/write/invalidate),TARGET(n/a)  ie   myMethod,read,myCache", s));
            }
        }
        catch (Exception e) {
            throw new CacheConfigurationRuntimeException(MessageFormat.format("Invalid Configuration {0}, configuration must follow the format METHODNAME(n/a),OPERATION(read/write/invalidate),TARGET(n/a)  ie   myMethod,read,myCache", s), e);
        }
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public InterceptorMetadata.Operation getOperation() {
        return this.operation;
    }

    public void setOperation(InterceptorMetadata.Operation operation) {
        this.operation = operation;
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public String toString() {
        return "CachingProxyConfigEntry{methodName='" + this.methodName + '\'' + ", operation=" + (Object)((Object)this.operation) + ", target='" + this.target + '\'' + '}';
    }
}

