/*
 * Decompiled with CFR 0.152.
 */
package tech.rsqn.cacheservice.interceptors;

import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInvocation;
import tech.rsqn.cacheservice.TransparentCacheService;
import tech.rsqn.cacheservice.support.DelimitedKey;
import tech.rsqn.reflectionhelpers.ReflectionHelper;

public class InterceptorUtil {
    public static String generateCacheKeyBasedOnMethodInvocation(TransparentCacheService cache, MethodInvocation invocation) {
        Object[] args = invocation.getArguments();
        Method targetMethod = invocation.getMethod();
        DelimitedKey builder = DelimitedKey.with(targetMethod.getDeclaringClass().getName()).and(targetMethod.getName());
        String recognisedTypeKey = null;
        for (Object arg : args) {
            if (ReflectionHelper.isPrimitiveOrStringOrWrapper((Object)arg)) {
                builder = builder.and(arg.toString());
                continue;
            }
            recognisedTypeKey = cache.generateParameterKey(arg);
            if (recognisedTypeKey != null) {
                builder = builder.and(recognisedTypeKey);
                continue;
            }
            return null;
        }
        return builder.toString();
    }
}

