/*
 * Decompiled with CFR 0.152.
 */
package tech.rsqn.cacheservice.interceptors;

import java.util.ArrayList;
import java.util.List;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;
import tech.rsqn.cacheservice.interceptors.AbstractInterceptor;
import tech.rsqn.cacheservice.interceptors.InterceptorMetadata;
import tech.rsqn.cacheservice.proxy.CachingProxyConfigEntry;

public class ConfiguredCacheInterceptor
extends AbstractInterceptor {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private List<CachingProxyConfigEntry> config;

    @Required
    public void setConfiguration(List<String> configStrings) {
        this.log.info("CachingProxy factory created");
        this.config = new ArrayList<CachingProxyConfigEntry>();
        for (String s : configStrings) {
            CachingProxyConfigEntry entry = new CachingProxyConfigEntry();
            entry.parseFromString(s);
            this.config.add(entry);
            this.log.info(s);
        }
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        String methodName = invocation.getMethod().getName();
        for (CachingProxyConfigEntry configEntry : this.config) {
            if (!methodName.equals(configEntry.getMethodName())) continue;
            InterceptorMetadata meta = InterceptorMetadata.with(configEntry.getOperation(), configEntry.getTarget());
            if (InterceptorMetadata.Operation.Read.equals((Object)configEntry.getOperation())) {
                return this.cacheService.aroundReadMethodInvocation(invocation, meta);
            }
            if (InterceptorMetadata.Operation.Write.equals((Object)configEntry.getOperation())) {
                return this.cacheService.aroundWriteMethodInvocation(invocation, meta);
            }
            if (!InterceptorMetadata.Operation.Invalidate.equals((Object)configEntry.getOperation())) continue;
            return this.cacheService.aroundInvalidateMethodInvocation(invocation, meta);
        }
        return invocation.proceed();
    }
}

