/*
 * Decompiled with CFR 0.152.
 */
package tech.rsqn.cacheservice.hashmapcache;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import tech.rsqn.cacheservice.CacheService;
import tech.rsqn.cacheservice.support.CacheIteratorCallBack;
import tech.rsqn.cacheservice.support.DefaultCacheEntryValue;

public class ReferenceHashMapCacheService
implements CacheService {
    private Map<String, DefaultCacheEntryValue> map = new HashMap<String, DefaultCacheEntryValue>();
    private int maxSize = 10000;
    private int trimTo = 5000;

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

    public void setTrimTo(int trimTo) {
        this.trimTo = trimTo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void houseKeep() {
        if (this.map.size() >= this.maxSize) {
            Map<String, DefaultCacheEntryValue> map = this.map;
            synchronized (map) {
                CopyOnWriteArrayList<DefaultCacheEntryValue> values = new CopyOnWriteArrayList<DefaultCacheEntryValue>();
                values.addAll(this.map.values());
                for (DefaultCacheEntryValue value : values) {
                    if (value.isValid()) continue;
                    this.remove(value.getKey());
                }
                values.clear();
                values.addAll(this.map.values());
                if (values.size() > this.trimTo) {
                    int target = values.size() - this.trimTo;
                    int c = 0;
                    for (DefaultCacheEntryValue value : values) {
                        this.remove(value.getKey());
                        if (c++ != target) continue;
                        break;
                    }
                }
            }
        }
    }

    @Override
    public <V> boolean containsValue(V value) {
        return this.map.containsValue(DefaultCacheEntryValue.with("", value));
    }

    @Override
    public <V extends Serializable> void put(String key, V value) {
        this.houseKeep();
        this.map.put(key, DefaultCacheEntryValue.with(key, value));
    }

    @Override
    public <V extends Serializable> void putWithTTL(String key, V value, int timeToLiveSeconds) {
        this.houseKeep();
        this.map.put(key, DefaultCacheEntryValue.with(key, value).andTimeToLiveSeconds(timeToLiveSeconds));
    }

    @Override
    public <V extends Serializable> V get(String key) {
        DefaultCacheEntryValue v = this.map.get(key);
        if (v != null) {
            if (v.isValid()) {
                return (V)((Serializable)v.getValue());
            }
            this.map.remove(key);
        }
        return null;
    }

    @Override
    public int remove(String key) {
        if (this.map.remove(key) != null) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean containsKey(String key) {
        return this.map.containsKey(key);
    }

    @Override
    public void iterateThroughKeys(CacheIteratorCallBack callBack) {
        String t;
        ArrayList<String> l = new ArrayList<String>();
        l.addAll(this.map.keySet());
        Iterator iterator = l.iterator();
        while (iterator.hasNext() && callBack.onCallBack(t = (String)iterator.next())) {
        }
    }

    @Override
    public long count() {
        return this.map.size();
    }

    @Override
    public long clear() {
        long v = this.map.size();
        this.map.clear();
        return v;
    }
}

