/*
 * Decompiled with CFR 0.152.
 */
package tech.rsqn.utils.jjst.servlets;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.rsqn.utils.jjst.servlets.AbstractContentServlet;

public abstract class AbstractAggregationServlet
extends AbstractContentServlet {
    public static final String CLEAR_CACHE = "clearcache";
    public static final String NO_CACHE = "nocache";
    private static Logger log = LoggerFactory.getLogger(AbstractAggregationServlet.class);
    private static final Map<String, String> cache = new Hashtable<String, String>();
    private String baseProfiles;

    private String generateCacheKey(String path, List profiles) {
        return path + profiles;
    }

    @Override
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.baseProfiles = config.getInitParameter("baseProfiles") != null ? config.getInitParameter("baseProfiles") : "";
    }

    @Override
    @Deprecated
    protected File resolveFile(File cwd, String relativePath) throws IOException {
        File f = new File(cwd, relativePath);
        return f;
    }

    @Override
    @Deprecated
    protected String getFileContents(File f) throws IOException {
        String content = new String(Files.readAllBytes(f.toPath()));
        return content;
    }

    @Override
    protected abstract String getContentType();

    protected abstract String processFileContent(String var1);

    protected abstract String postProcess(String var1);

    @Override
    protected String getContent(HttpServletRequest request) throws ServletException, IOException {
        String cacheKey;
        String[] profileSplit;
        String contents = null;
        File tld = new File(this.getServletContext().getRealPath("/"));
        String path = request.getRequestURI();
        String profileArgs = request.getParameter("profiles");
        ArrayList<String> profileList = new ArrayList<String>();
        if (this.baseProfiles != null) {
            profileSplit = this.baseProfiles.split(",");
            Collections.addAll(profileList, profileSplit);
        }
        if (profileArgs != null) {
            profileSplit = profileArgs.split(",");
            Collections.addAll(profileList, profileSplit);
        }
        if (profileList.contains(CLEAR_CACHE)) {
            cache.clear();
        }
        if ((contents = cache.get(cacheKey = this.generateCacheKey(path, profileList))) == null || profileList.contains(NO_CACHE)) {
            log.debug("Profiles = " + profileList);
            StringBuffer buffer = new StringBuffer();
            this.aggregateFromFile(buffer, tld, path, profileList);
            contents = buffer.toString();
            contents = this.postProcess(contents);
            cache.put(this.generateCacheKey(path, profileList), contents);
            log.info("Aggregation of {} complete", (Object)path);
        } else {
            log.trace("Returning {} from cache ", (Object)path);
        }
        return contents;
    }

    protected void aggregateFromFile(StringBuffer buffer, File cwd, String fileName, List<String> profiles) throws IOException {
        String line;
        String includeToken = "#include";
        String ifProfileToken = "#ifprofile";
        String ifNotProfileToken = "#ifnot_profile";
        String endIfToken = "#endif";
        File f = this.resolveFile(cwd, fileName);
        File nCwd = f.getParentFile();
        String baseContents = this.resolveContent(f, fileName);
        BufferedReader reader = new BufferedReader(new StringReader(baseContents));
        boolean DEFAULT_STATE = false;
        boolean IN_PROFILE_STATE_IGNORE = true;
        int IN_PROFILE_STATE_PROCESS = 2;
        int state = 0;
        while ((line = reader.readLine()) != null) {
            String profileName;
            if ((state == 1 || state == 2) && line.trim().startsWith(endIfToken)) {
                state = 0;
                continue;
            }
            if (state == 1) continue;
            if (line.trim().startsWith(includeToken)) {
                String includeFileName = line.replace(includeToken, "").trim();
                buffer.append("\n\n\n");
                buffer.append("/* " + includeFileName + " */");
                buffer.append("\n\n");
                this.aggregateFromFile(buffer, nCwd, includeFileName, profiles);
                continue;
            }
            if (line.trim().startsWith(ifProfileToken)) {
                profileName = line.replace(ifProfileToken, "").trim();
                log.debug("IfProfile [" + profileName + "]");
                if (profiles.contains(profileName)) {
                    state = 2;
                    log.debug("IfProfile process [" + profileName + "]");
                    continue;
                }
                log.debug("IfProfile ignore [" + profileName + "]");
                state = 1;
                continue;
            }
            if (line.trim().startsWith(ifNotProfileToken)) {
                profileName = line.replace(ifNotProfileToken, "").trim();
                log.debug("IfNotProfile [" + profileName + "]");
                if (profiles.contains(profileName)) {
                    log.debug("IfNotProfile ignoring [" + profileName + "]");
                    state = 1;
                    continue;
                }
                state = 2;
                log.debug("IfNotProfile processing [" + profileName + "]");
                continue;
            }
            buffer.append(line);
            buffer.append("\n");
        }
    }
}

