/*
 * Decompiled with CFR 0.152.
 */
package com.rsqn.utils.jjst.servlets;

import com.rsqn.utils.jjst.util.ResourceUtil;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractContentServlet
extends HttpServlet {
    private static Logger log = LoggerFactory.getLogger(AbstractContentServlet.class);

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }

    protected File resolveFile(File cwd, String relativePath) throws IOException {
        File f = new File(cwd, relativePath);
        return f;
    }

    protected String getFileContents(File f) throws IOException {
        String content = new String(Files.readAllBytes(f.toPath()));
        return content;
    }

    protected abstract String getContentType();

    protected abstract String getContent(HttpServletRequest var1) throws ServletException, IOException;

    protected File resolveRelativeFileFromUri(HttpServletRequest request) throws ServletException, IOException {
        String bootPath = request.getRequestURI();
        File tld = new File(this.getServletContext().getRealPath("/"));
        File bootFile = new File(this.getServletContext().getRealPath(bootPath));
        if (!bootFile.getAbsolutePath().contains(tld.getAbsolutePath())) {
            throw new ServletException("Invalid Path");
        }
        return bootFile;
    }

    protected String resolveContent(File f, String path) throws IOException {
        File tld = new File(this.getServletContext().getRealPath("/"));
        String content = "";
        if (f != null && f.exists()) {
            if (!f.getAbsolutePath().contains(tld.getAbsolutePath())) {
                throw new IOException("Invalid Path");
            }
            content = new String(Files.readAllBytes(f.toPath()));
        } else {
            content = ResourceUtil.loadContentFromResource(path);
        }
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        response.setContentType(this.getContentType());
        String contents = this.getContent(request);
        try (PrintWriter out = response.getWriter();){
            out.write(contents);
        }
    }
}

