/*
 * Decompiled with CFR 0.152.
 */
package tech.prodigio.core.springcloudgateway.utils;

import java.nio.charset.StandardCharsets;
import java.util.List;
import org.reactivestreams.Publisher;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.server.reactive.ServerHttpResponse;
import reactor.core.publisher.Mono;

public class RequestUtils {
    public static final String ERROR_401 = "{\n    \"status\": 401,\n    \"message\": \"No Autorizado\"\n}\n";
    public static final String ERROR_403 = "{\n    \"status\": 403,\n    \"code\": 40300,\n    \"entityTypeName\": \"ServiceAccess\",\n    \"message\": \"Acceso Denegado\"\n}\n";

    private RequestUtils() {
    }

    public static HttpHeaders getOnlyAllowedHeaders(HttpHeaders originalHeaders, List<String> headersToKeep) {
        HttpHeaders filteredHeaders = new HttpHeaders();
        List<String> lowerCaseHeaders = headersToKeep.stream().map(String::toLowerCase).toList();
        originalHeaders.entrySet().stream().filter(entry -> lowerCaseHeaders.contains(((String)entry.getKey()).toLowerCase())).forEach(entry -> filteredHeaders.addAll((String)entry.getKey(), (List)entry.getValue()));
        return filteredHeaders;
    }

    public static void write401(ServerHttpResponse response) {
        response.setStatusCode(HttpStatusCode.valueOf((int)401));
        RequestUtils.writeResponse(response, ERROR_401);
    }

    public static Mono<Void> write403(ServerHttpResponse response) {
        response.setStatusCode(HttpStatusCode.valueOf((int)403));
        return RequestUtils.writeResponse(response, ERROR_403);
    }

    public static Mono<Void> writeResponse(ServerHttpResponse response, String body) {
        response.getHeaders().setContentType(MediaType.APPLICATION_JSON);
        return response.writeWith((Publisher)Mono.just((Object)response.bufferFactory().wrap(body.getBytes(StandardCharsets.UTF_8))));
    }
}

