/*
 * Decompiled with CFR 0.152.
 */
package tech.prodigio.core.springcloudgateway.filter;

import java.util.Optional;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.factory.AbstractGatewayFilterFactory;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.stereotype.Component;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;
import tech.prodigio.core.libcoresecurity.utils.JwtUtils;

@Component
public class InjectHeaderFromJwtFilter
extends AbstractGatewayFilterFactory<Config> {
    @Generated
    private static final Logger log = LogManager.getLogger(InjectHeaderFromJwtFilter.class);

    public InjectHeaderFromJwtFilter() {
        super(Config.class);
    }

    public GatewayFilter apply(Config config) {
        return (exchange, chain) -> {
            ServerHttpRequest request = exchange.getRequest();
            return InjectHeaderFromJwtFilter.getFieldFromJwt(config, request).map(headerContent -> InjectHeaderFromJwtFilter.addRequestHeader(config, exchange, chain, headerContent, request)).orElse(chain.filter(exchange));
        };
    }

    private static Optional<String> getFieldFromJwt(Config config, ServerHttpRequest request) {
        return JwtUtils.getFieldFromPayload((String)request.getHeaders().getFirst("Authorization"), (String)config.payloadProperty);
    }

    private static Mono<Void> addRequestHeader(Config config, ServerWebExchange exchange, GatewayFilterChain chain, String headerContent, ServerHttpRequest request) {
        log.info("add {} header to request", (Object)config.headerNameTarget);
        return chain.filter(exchange.mutate().request(request.mutate().header(config.headerNameTarget, new String[]{headerContent}).build()).build());
    }

    public static class Config {
        private String payloadProperty;
        private String headerNameTarget;

        @Generated
        public void setPayloadProperty(String payloadProperty) {
            this.payloadProperty = payloadProperty;
        }

        @Generated
        public void setHeaderNameTarget(String headerNameTarget) {
            this.headerNameTarget = headerNameTarget;
        }
    }
}

