/*
 * Decompiled with CFR 0.152.
 */
package tech.prodigio.core.springcloudgateway.filter;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.factory.AbstractGatewayFilterFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.stereotype.Component;
import tech.prodigio.core.springcloudgateway.utils.RequestUtils;

@Component
public class IncludeHeadersFilter
extends AbstractGatewayFilterFactory<Config> {
    @Generated
    private static final Logger log = LogManager.getLogger(IncludeHeadersFilter.class);
    private static final List<String> DEFAULT_HEADERS_TO_KEEP = List.of("x-trace-id", "Content-Type", "User-Agent");

    public IncludeHeadersFilter() {
        super(Config.class);
    }

    public GatewayFilter apply(Config config) {
        return (exchange, chain) -> {
            ServerHttpRequest request = exchange.getRequest();
            log.info("ORIGINAL REQUEST HEADERS : {}", (Object)request.getHeaders());
            ServerHttpRequest.Builder requestBuilder = request.mutate();
            HttpHeaders filteredHeaders = RequestUtils.getOnlyAllowedHeaders(request.getHeaders(), config.customWhiteListOrDefault());
            requestBuilder.headers(httpHeaders -> {
                httpHeaders.clear();
                httpHeaders.putAll((Map)filteredHeaders);
            });
            log.info("FILTERED REQUEST HEADERS : {}", (Object)filteredHeaders);
            return chain.filter(exchange.mutate().request(requestBuilder.build()).build());
        };
    }

    public static class Config {
        private List<String> headerNames;

        public List<String> customWhiteListOrDefault() {
            if (Objects.nonNull(this.headerNames) && !this.headerNames.isEmpty()) {
                this.headerNames.addAll(DEFAULT_HEADERS_TO_KEEP);
                return this.headerNames;
            }
            return DEFAULT_HEADERS_TO_KEEP;
        }

        @Generated
        public void setHeaderNames(List<String> headerNames) {
            this.headerNames = headerNames;
        }
    }
}

