/*
 * Decompiled with CFR 0.152.
 */
package tech.prodigio.core.libcorelogging.messageformat;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Optional;
import org.springframework.stereotype.Component;
import tech.prodigio.core.libcorelogging.enums.MessageFormatType;
import tech.prodigio.core.libcorelogging.messageformat.ObjectMessageFormatter;

@Component
public class FormatThrowableObjects
implements ObjectMessageFormatter {
    private static String stackTraceToString(Throwable obj) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        obj.printStackTrace(printWriter);
        return stringWriter.toString();
    }

    @Override
    public String objectToMessage(Object object) {
        return Optional.ofNullable(object).map(Throwable.class::cast).map(FormatThrowableObjects::stackTraceToString).orElse("");
    }

    @Override
    public MessageFormatType getType() {
        return MessageFormatType.THROWABLE;
    }
}

