/*
 * Decompiled with CFR 0.152.
 */
package tech.prodigio.core.libcorelogging.layout;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.LayoutBase;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.MinimalPrettyPrinter;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.time.LocalDateTime;
import tech.prodigio.core.libcorelogging.LoggingContext;

public class LoggingLayout
extends LayoutBase<ILoggingEvent> {
    private static final String LOGGING_CONTEXT_SIGNATURE = LoggingContext.class.getSimpleName();
    public static final ObjectMapper objectMapper = LoggingLayout.getObjectMapper();

    public String doLayout(ILoggingEvent event) {
        String message = event.getMessage();
        if (message.contains(LOGGING_CONTEXT_SIGNATURE)) {
            return message;
        }
        return this.formatMessage(event);
    }

    private String formatMessage(ILoggingEvent event) {
        LoggingContext context = LoggingContext.builder().severity(event.getLevel().toString()).timestamp(LocalDateTime.now()).message(event.getMessage()).className(event.getLoggerName()).build();
        try {
            return objectMapper.writeValueAsString((Object)context) + "\n";
        }
        catch (JsonProcessingException e) {
            return context.getMessage();
        }
    }

    private static ObjectMapper getObjectMapper() {
        return new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).registerModule((Module)new JavaTimeModule()).enable(SerializationFeature.INDENT_OUTPUT).setDefaultPrettyPrinter((PrettyPrinter)new MinimalPrettyPrinter());
    }
}

