/*
 * Decompiled with CFR 0.152.
 */
package tech.prodigio.core.libcorelogging.config;

import java.util.List;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import tech.prodigio.core.libcorelogging.LogBackLogger;
import tech.prodigio.core.libcorelogging.Logger;
import tech.prodigio.core.libcorelogging.SingletonLogBackLogger;
import tech.prodigio.core.libcorelogging.SingletonLogger;
import tech.prodigio.core.libcorelogging.messageformat.ObjectMessageFormatter;

@Configuration
@ComponentScan(basePackages={"cl.prodigio.libcorelogging.messageformat"})
public class LogConfiguration {
    @Value(value="${lib.core.logging.filter-package-start-with:tech.prodigio}")
    private String packageStartsWith;

    @Bean
    @Scope(value="request", proxyMode=ScopedProxyMode.TARGET_CLASS)
    Logger getLogger() {
        return new LogBackLogger(this.packageStartsWith);
    }

    @Bean
    public SingletonLogger singletonLogger(List<ObjectMessageFormatter> formatters) {
        return new SingletonLogBackLogger(formatters, this.packageStartsWith);
    }
}

