/*
 * Decompiled with CFR 0.152.
 */
package tech.prodigio.core.libcorelogging;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.text.MessageFormat;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.logging.log4j.Level;
import org.slf4j.LoggerFactory;
import tech.prodigio.core.libcorelogging.Logger;
import tech.prodigio.core.libcorelogging.LoggingContext;
import tech.prodigio.core.libcorelogging.enums.MessageFormatType;
import tech.prodigio.core.libcorelogging.layout.LoggingLayout;
import tech.prodigio.core.libcorelogging.messageformat.FormatGenericObject;
import tech.prodigio.core.libcorelogging.messageformat.FormatThrowableObjects;
import tech.prodigio.core.libcorelogging.messageformat.ObjectMessageFormatter;

public class LogBackLogger
implements Logger {
    private static final String INFO = Level.INFO.toString();
    private static final String WARN = Level.WARN.toString();
    private static final String ERROR = Level.ERROR.toString();
    private final String packageStartsWith;
    private static final ObjectMapper objectMapper = LoggingLayout.objectMapper;
    private final Map<MessageFormatType, ObjectMessageFormatter> objectMessageFormatters = Map.of(MessageFormatType.THROWABLE, new FormatThrowableObjects(), MessageFormatType.GENETIC_OBJECT, new FormatGenericObject());
    private final org.slf4j.Logger log = LoggerFactory.getLogger(LogBackLogger.class);
    private LoggingContext loggingContext;

    @Override
    public void info(String message, Object ... args) {
        String msg = this.formatMessage(message, INFO, args);
        this.log.info(msg);
    }

    @Override
    public void warn(String message, Object ... args) {
        String msg = this.formatMessage(message, WARN, args);
        this.log.warn(msg);
    }

    @Override
    public void error(String message, Object ... args) {
        String msg = this.formatMessage(message, ERROR, args);
        this.log.error(msg);
    }

    @Override
    public LoggingContext getContext() {
        return this.loggingContext;
    }

    @Override
    public void setContext(LoggingContext loggingContext) {
        this.loggingContext = loggingContext;
    }

    private String formatMessage(String message, String level, Object[] args) {
        message = String.valueOf(message);
        String msg = this.formatArgs(message, args);
        return this.buildMessage(level, msg);
    }

    private String formatArgs(String message, Object ... args) {
        Object[] formattedMessage = Arrays.stream(args).map(obj -> this.getObjectMessageFormatter(obj).objectToMessage(obj)).toArray();
        return formattedMessage.length > 0 ? MessageFormat.format(message, formattedMessage) : message;
    }

    private ObjectMessageFormatter getObjectMessageFormatter(Object obj) {
        return this.objectMessageFormatters.get((Object)MessageFormatType.getObjectType(obj));
    }

    private String buildMessage(String level, String message) {
        String messageTemplate = String.format("[%s] %s %s", level, this.log.getName(), message);
        if (Objects.isNull(this.loggingContext)) {
            return this.toJson(LoggingContext.builder().severity(level).timestamp(LocalDateTime.now()).message(messageTemplate).build());
        }
        this.loggingContext.setTimestamp(LocalDateTime.now());
        this.loggingContext.setSeverity(level);
        this.loggingContext.setMessage(messageTemplate);
        this.setContextCallerInfo();
        return this.toJson(this.loggingContext);
    }

    private String toJson(LoggingContext context) {
        try {
            return objectMapper.writeValueAsString((Object)context) + "\n";
        }
        catch (JsonProcessingException e) {
            return context.getMessage() + "\n";
        }
    }

    private void setContextCallerInfo() {
        Arrays.stream(Thread.currentThread().getStackTrace()).filter(element -> !element.getClassName().contains(this.getClass().getSimpleName())).filter(element -> element.getClassName().startsWith(this.packageStartsWith)).findFirst().ifPresent(element -> {
            this.loggingContext.setClassName(element.getClassName());
            this.loggingContext.setMethodName(element.getMethodName());
            this.loggingContext.setLineNumber(element.getLineNumber());
        });
    }

    @Generated
    public LogBackLogger(String packageStartsWith) {
        this.packageStartsWith = packageStartsWith;
    }
}

