/*
 * Decompiled with CFR 0.152.
 */
package tech.prodigio.core.libcorebase.utils;

import java.util.Optional;

public class ConversionUtils {
    private ConversionUtils() {
    }

    public static Integer parseIntOrDefault(String value, Integer defaultValue) {
        return ConversionUtils.parseIntOptional(value).orElse(defaultValue);
    }

    public static Optional<Integer> parseIntOptional(String value) {
        try {
            return Optional.of(Integer.parseInt(value));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public static Integer parseInt(String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Long parseLongOrDefault(String value, Long defaultValue) {
        return ConversionUtils.parseLongOptional(value).orElse(defaultValue);
    }

    public static Optional<Long> parseLongOptional(String value) {
        try {
            return Optional.of(Long.parseLong(value));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public static Long parseLong(String value) {
        try {
            return Long.parseLong(value);
        }
        catch (Exception e) {
            return null;
        }
    }
}

