/*
 * Decompiled with CFR 0.152.
 */
package tech.powerscheduler.worker.processor;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.powerscheduler.common.enums.ScriptTypeEnum;
import tech.powerscheduler.worker.job.JobContext;
import tech.powerscheduler.worker.job.ScriptJobContext;
import tech.powerscheduler.worker.processor.ProcessResult;
import tech.powerscheduler.worker.processor.Processor;
import tech.powerscheduler.worker.util.ConstKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u000e\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\u0004\u0018\u00010\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0015"}, d2={"Ltech/powerscheduler/worker/processor/ScriptProcessor;", "Ltech/powerscheduler/worker/processor/Processor;", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "process", "Ltech/powerscheduler/worker/processor/ProcessResult;", "context", "Ltech/powerscheduler/worker/job/JobContext;", "doProcess", "Ltech/powerscheduler/worker/job/ScriptJobContext;", "readAndCloseInputStream", "", "inputStream", "Ljava/io/InputStream;", "path", "getPath", "()Ljava/lang/String;", "Companion", "power-scheduler-worker"})
@SourceDebugExtension(value={"SMAP\nScriptProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScriptProcessor.kt\ntech/powerscheduler/worker/processor/ScriptProcessor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,75:1\n1#2:76\n*E\n"})
public final class ScriptProcessor
implements Processor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final Logger log = LoggerFactory.getLogger(ScriptProcessor.class);
    @NotNull
    public static final String PROCESSOR_PATH = "ScriptProcessor";

    @Override
    @NotNull
    public ProcessResult process(@NotNull JobContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return this.doProcess((ScriptJobContext)context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final ProcessResult doProcess(@NotNull ScriptJobContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        File dir = new File(ConstKt.getSCRIPT_DIR());
        if (!dir.exists()) {
            dir.mkdir();
        }
        ScriptTypeEnum scriptType = context.getScriptType();
        StringBuilder stringBuilder = new StringBuilder().append(ConstKt.getSCRIPT_DIR()).append(File.separator).append(context.getJobInstanceId());
        ScriptTypeEnum scriptTypeEnum = scriptType;
        Intrinsics.checkNotNull((Object)scriptTypeEnum);
        String scriptFilePath = stringBuilder.append(scriptTypeEnum.getSuffix()).toString();
        File file = new File(scriptFilePath);
        try {
            String string = context.getScriptCode();
            if (string == null) {
                string = "";
            }
            FilesKt.writeText((File)file, (String)string, (Charset)Charsets.UTF_8);
        }
        catch (Exception e) {
            return ProcessResult.Companion.failure("Failed to write script file: " + e.getMessage());
        }
        try {
            String[] stringArray = new String[]{scriptType.getExecutor(), scriptFilePath};
            Process process = new ProcessBuilder(stringArray).start();
            int exitCode = process.waitFor();
            Closeable closeable = process.getOutputStream();
            Throwable throwable = null;
            try {
                OutputStream it = (OutputStream)closeable;
                boolean bl = false;
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            InputStream inputStream = process.getInputStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
            String message = this.readAndCloseInputStream(inputStream);
            InputStream inputStream2 = process.getErrorStream();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream2, (String)"getErrorStream(...)");
            String errorMessage = this.readAndCloseInputStream(inputStream2);
            if (exitCode == 0 && ((CharSequence)errorMessage).length() == 0) {
                file.delete();
                this.log.info("Success to process scriptJob [{}]: message={}", (Object)context.getJobInstanceId(), (Object)message);
                return ProcessResult.Companion.success();
            }
            this.log.warn("Failed to process scriptJob [{}]: errorMessage={}", (Object)context.getJobInstanceId(), (Object)errorMessage);
            return ProcessResult.Companion.failure(errorMessage);
        }
        catch (Exception e) {
            return ProcessResult.Companion.failure("Script execution failed: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String readAndCloseInputStream(InputStream inputStream) {
        String string;
        Closeable closeable = new BufferedReader(new InputStreamReader(inputStream));
        Throwable throwable = null;
        try {
            BufferedReader reader = (BufferedReader)closeable;
            boolean bl = false;
            string = ((Object)StringsKt.trim((CharSequence)TextStreamsKt.readText((Reader)reader))).toString();
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return string;
    }

    @Override
    @Nullable
    public String getPath() {
        return PROCESSOR_PATH;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Ltech/powerscheduler/worker/processor/ScriptProcessor$Companion;", "", "<init>", "()V", "PROCESSOR_PATH", "", "power-scheduler-worker"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

