/*
 * Decompiled with CFR 0.152.
 */
package tech.powerscheduler.worker.processor;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.powerscheduler.worker.processor.Processor;
import tech.powerscheduler.worker.processor.ScriptProcessor;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nH\u0007J\u0014\u0010\u000e\u001a\u0004\u0018\u00010\n2\b\u0010\u000f\u001a\u0004\u0018\u00010\tH\u0007R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Ltech/powerscheduler/worker/processor/ProcessorRegistry;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "REGISTRY", "", "", "Ltech/powerscheduler/worker/processor/Processor;", "register", "", "processor", "find", "processorPath", "power-scheduler-worker"})
public final class ProcessorRegistry {
    @NotNull
    public static final ProcessorRegistry INSTANCE = new ProcessorRegistry();
    private static final Logger log = LoggerFactory.getLogger(ProcessorRegistry.class);
    @NotNull
    private static final Map<String, Processor> REGISTRY = new ConcurrentHashMap();

    private ProcessorRegistry() {
    }

    @JvmStatic
    public static final void register(@NotNull Processor processor) {
        Intrinsics.checkNotNullParameter((Object)processor, (String)"processor");
        CharSequence charSequence = processor.getPath();
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            log.error("register " + Reflection.getOrCreateKotlinClass(processor.getClass()).getSimpleName() + " failed, path cannot be null or blank!");
        } else {
            String string = processor.getPath();
            Intrinsics.checkNotNull((Object)string);
            REGISTRY.put(string, processor);
        }
    }

    @JvmStatic
    @Nullable
    public static final Processor find(@Nullable String processorPath) {
        return REGISTRY.get(processorPath);
    }

    static {
        ProcessorRegistry.register(new ScriptProcessor());
    }
}

