/*
 * Decompiled with CFR 0.152.
 */
package tech.powerscheduler.worker.persistence;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.io.File;
import java.sql.Connection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import tech.powerscheduler.worker.util.ConstKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\n\u001a\u00020\u000bJ\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Ltech/powerscheduler/worker/persistence/DataSourceManager;", "", "<init>", "()V", "DB_FILE", "", "hikariConfig", "Lcom/zaxxer/hikari/HikariConfig;", "dataSource", "Lcom/zaxxer/hikari/HikariDataSource;", "getConnection", "Ljava/sql/Connection;", "closeDataSource", "", "power-scheduler-worker"})
public final class DataSourceManager {
    @NotNull
    public static final DataSourceManager INSTANCE;
    @NotNull
    private static final String DB_FILE;
    @NotNull
    private static final HikariConfig hikariConfig;
    @NotNull
    private static final HikariDataSource dataSource;

    private DataSourceManager() {
    }

    @NotNull
    public final Connection getConnection() {
        Connection connection = dataSource.getConnection();
        Intrinsics.checkNotNullExpressionValue((Object)connection, (String)"getConnection(...)");
        return connection;
    }

    public final void closeDataSource() {
        dataSource.close();
        String dbFilePath = ConstKt.getH2_DIR() + '/' + DB_FILE + ".mv.db";
        File dbFile = new File(dbFilePath);
        dbFile.delete();
    }

    static {
        HikariConfig hikariConfig;
        INSTANCE = new DataSourceManager();
        String string = System.getenv("DB_FILE");
        if (string == null) {
            string = "data";
        }
        DB_FILE = string;
        HikariConfig $this$hikariConfig_u24lambda_u240 = hikariConfig = new HikariConfig();
        boolean bl = false;
        $this$hikariConfig_u24lambda_u240.setJdbcUrl("jdbc:h2:file:" + ConstKt.getH2_DIR() + '/' + DB_FILE + ";DB_CLOSE_ON_EXIT=FALSE");
        $this$hikariConfig_u24lambda_u240.setUsername("sa");
        $this$hikariConfig_u24lambda_u240.setPassword("");
        $this$hikariConfig_u24lambda_u240.setDriverClassName("org.h2.Driver");
        $this$hikariConfig_u24lambda_u240.setMaximumPoolSize(20);
        $this$hikariConfig_u24lambda_u240.setMinimumIdle(2);
        $this$hikariConfig_u24lambda_u240.setIdleTimeout(60000L);
        $this$hikariConfig_u24lambda_u240.setConnectionTimeout(2000L);
        $this$hikariConfig_u24lambda_u240.setMaxLifetime(1800000L);
        DataSourceManager.hikariConfig = hikariConfig;
        dataSource = new HikariDataSource(DataSourceManager.hikariConfig);
    }
}

