/*
 * Decompiled with CFR 0.152.
 */
package tech.powerscheduler.worker;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.AwaitKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.powerscheduler.worker.PowerSchedulerWorkerHttpClient;
import tech.powerscheduler.worker.ServerDiscoveryService;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u0013J\u0014\u0010\u0015\u001a\u00020\u00132\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\u0017J \u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00042\b\b\u0002\u0010\u0019\u001a\u00020\u001aH\u0082@\u00a2\u0006\u0002\u0010\u001bR\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Ltech/powerscheduler/worker/ServerDiscoveryService;", "", "seedNodes", "", "", "<init>", "(Ljava/util/Set;)V", "availableServerUrls", "", "getAvailableServerUrls", "()Ljava/util/Set;", "httpClient", "Ltech/powerscheduler/worker/PowerSchedulerWorkerHttpClient;", "scheduledThreadPoolExecutor", "Ljava/util/concurrent/ScheduledThreadPoolExecutor;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "start", "", "stop", "checkServerAvailable", "servers", "", "server", "attemptCnt", "", "(Ljava/lang/String;ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "power-scheduler-worker"})
public final class ServerDiscoveryService {
    @NotNull
    private final Set<String> seedNodes;
    @NotNull
    private final Set<String> availableServerUrls;
    @NotNull
    private final PowerSchedulerWorkerHttpClient httpClient;
    @NotNull
    private final ScheduledThreadPoolExecutor scheduledThreadPoolExecutor;
    private final Logger log;

    public ServerDiscoveryService(@NotNull Set<String> seedNodes) {
        Intrinsics.checkNotNullParameter(seedNodes, (String)"seedNodes");
        this.seedNodes = seedNodes;
        this.availableServerUrls = new LinkedHashSet();
        this.httpClient = new PowerSchedulerWorkerHttpClient();
        this.scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(1);
        this.log = LoggerFactory.getLogger(ServerDiscoveryService.class);
    }

    @NotNull
    public final Set<String> getAvailableServerUrls() {
        return this.availableServerUrls;
    }

    public final void start() {
        this.checkServerAvailable((Iterable<String>)this.seedNodes);
        this.scheduledThreadPoolExecutor.scheduleWithFixedDelay(() -> ServerDiscoveryService.start$lambda$0(this), 3L, 5L, TimeUnit.SECONDS);
    }

    public final void stop() {
        this.scheduledThreadPoolExecutor.shutdownNow();
        this.log.info("[PowerScheduler] {} stopped", (Object)this.getClass().getSimpleName());
    }

    public final synchronized void checkServerAvailable(@NotNull Iterable<String> servers) {
        Intrinsics.checkNotNullParameter(servers, (String)"servers");
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<? extends Unit>>, Object>(servers, this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ Iterable<String> $servers;
            final /* synthetic */ ServerDiscoveryService this$0;
            {
                this.$servers = $servers;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        ResultKt.throwOnFailure((Object)object);
                        CoroutineScope $this$runBlocking = (CoroutineScope)this.L$0;
                        Iterable<String> iterable = this.$servers;
                        ServerDiscoveryService serverDiscoveryService = this.this$0;
                        boolean $i$f$map = false;
                        void var6_7 = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            void server;
                            String string = (String)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl = false;
                            collection.add(BuildersKt.async$default((CoroutineScope)$this$runBlocking, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(serverDiscoveryService, (String)server, null){
                                int label;
                                final /* synthetic */ ServerDiscoveryService this$0;
                                final /* synthetic */ String $server;
                                {
                                    this.this$0 = $receiver;
                                    this.$server = $server;
                                    super(2, $completion);
                                }

                                /*
                                 * WARNING - void declaration
                                 * Enabled force condition propagation
                                 * Lifted jumps to return sites
                                 */
                                public final Object invokeSuspend(Object object) {
                                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)object);
                                            this.label = 1;
                                            Object object3 = ServerDiscoveryService.checkServerAvailable$default(this.this$0, this.$server, 0, (Continuation)this, 2, null);
                                            if (object3 != object2) return Unit.INSTANCE;
                                            return object2;
                                        }
                                        case 1: {
                                            void $result;
                                            ResultKt.throwOnFailure((Object)$result);
                                            Object object3 = $result;
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (int)3, null));
                        }
                        this.label = 1;
                        Object object3 = AwaitKt.awaitAll((Collection)((List)destination$iv$iv), (Continuation)((Continuation)this));
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super List<? extends Unit>>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)function2;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super List<Unit>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    /*
     * Unable to fully structure code
     */
    private final Object checkServerAvailable(String var1_1, int var2_2, Continuation<? super Unit> $completion) {
        if (!($completion instanceof checkServerAvailable.2)) ** GOTO lbl-1000
        var7_4 = $completion;
        if ((var7_4.label & -2147483648) != 0) {
            var7_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ ServerDiscoveryService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return ServerDiscoveryService.access$checkServerAvailable(this.this$0, null, 0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var8_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                result = this.httpClient.checkServerAvailable(server);
                if (result.getSuccess() && Intrinsics.areEqual((Object)result.getData(), (Object)Boxing.boxBoolean((boolean)true))) {
                    this.availableServerUrls.add(server);
                    break;
                }
                var5_8 = new Object[]{server, result.getMessage(), Boxing.boxInt((int)attemptCnt)};
                this.log.error("[Powerscheduler] checkServerAvailable failed: server={}, msg={}, attemptCnt={}", var5_8);
                if (attemptCnt == 3) {
                    this.availableServerUrls.remove(server);
                    return Unit.INSTANCE;
                }
                $continuation.L$0 = server;
                $continuation.I$0 = attemptCnt;
                $continuation.label = 1;
                v0 = DelayKt.delay((long)1000L, (Continuation)$continuation);
                if (v0 == var8_6) {
                    return var8_6;
                }
                ** GOTO lbl34
            }
            case 1: {
                attemptCnt = $continuation.I$0;
                server = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl34:
                // 2 sources

                $continuation.L$0 = null;
                $continuation.label = 2;
                v1 = this.checkServerAvailable(server, attemptCnt + 1, (Continuation<? super Unit>)$continuation);
                if (v1 == var8_6) {
                    return var8_6;
                }
                ** GOTO lbl43
            }
            case 2: {
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl43:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    static /* synthetic */ Object checkServerAvailable$default(ServerDiscoveryService serverDiscoveryService, String string, int n, Continuation continuation, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 1;
        }
        return serverDiscoveryService.checkServerAvailable(string, n, (Continuation<? super Unit>)continuation);
    }

    private static final void start$lambda$0(ServerDiscoveryService this$0) {
        this$0.checkServerAvailable((Iterable<String>)this$0.seedNodes);
    }

    public static final /* synthetic */ Object access$checkServerAvailable(ServerDiscoveryService $this, String server, int attemptCnt, Continuation $completion) {
        return $this.checkServerAvailable(server, attemptCnt, (Continuation<? super Unit>)$completion);
    }
}

