/*
 * Decompiled with CFR 0.152.
 */
package tech.powerscheduler.worker;

import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.powerscheduler.worker.EmbedServer;
import tech.powerscheduler.worker.JobExecutorService;
import tech.powerscheduler.worker.JobProgressReportService;
import tech.powerscheduler.worker.PowerSchedulerWorkerProperties;
import tech.powerscheduler.worker.ServerDiscoveryService;
import tech.powerscheduler.worker.WorkerRegisterService;
import tech.powerscheduler.worker.persistence.DataSourceManager;
import tech.powerscheduler.worker.util.ClasspathUtil;
import tech.powerscheduler.worker.util.JdbcUtilKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001BI\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\f\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\r\u0010\u000eB\u0011\b\u0016\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0004\b\r\u0010\u0011J\u0006\u0010\"\u001a\u00020#J\u0006\u0010$\u001a\u00020#J\b\u0010%\u001a\u00020#H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0015\u001a\n \u0017*\u0004\u0018\u00010\u00160\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Ltech/powerscheduler/worker/PowerSchedulerWorker;", "", "enabled", "", "endpoint", "", "", "appCode", "appSecret", "port", "", "externalHost", "externalPort", "<init>", "(ZLjava/util/Set;Ljava/lang/String;Ljava/lang/String;ILjava/lang/String;Ljava/lang/Integer;)V", "properties", "Ltech/powerscheduler/worker/PowerSchedulerWorkerProperties;", "(Ltech/powerscheduler/worker/PowerSchedulerWorkerProperties;)V", "Ljava/lang/Integer;", "destroyed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "serverDiscoveryService", "Ltech/powerscheduler/worker/ServerDiscoveryService;", "workerRegisterService", "Ltech/powerscheduler/worker/WorkerRegisterService;", "jobExecutorService", "Ltech/powerscheduler/worker/JobExecutorService;", "jobProgressReportService", "Ltech/powerscheduler/worker/JobProgressReportService;", "embedServer", "Ltech/powerscheduler/worker/EmbedServer;", "init", "", "destroy", "initDatabase", "power-scheduler-worker"})
public final class PowerSchedulerWorker {
    private final boolean enabled;
    @NotNull
    private final Set<String> endpoint;
    @NotNull
    private final String appCode;
    @NotNull
    private final String appSecret;
    private final int port;
    @Nullable
    private final String externalHost;
    @Nullable
    private final Integer externalPort;
    @NotNull
    private final AtomicBoolean destroyed;
    private final Logger log;
    @NotNull
    private final ServerDiscoveryService serverDiscoveryService;
    @NotNull
    private final WorkerRegisterService workerRegisterService;
    @NotNull
    private final JobExecutorService jobExecutorService;
    @NotNull
    private final JobProgressReportService jobProgressReportService;
    @NotNull
    private final EmbedServer embedServer;

    public PowerSchedulerWorker(boolean enabled, @NotNull Set<String> endpoint, @NotNull String appCode, @NotNull String appSecret, int port, @Nullable String externalHost, @Nullable Integer externalPort) {
        Intrinsics.checkNotNullParameter(endpoint, (String)"endpoint");
        Intrinsics.checkNotNullParameter((Object)appCode, (String)"appCode");
        Intrinsics.checkNotNullParameter((Object)appSecret, (String)"appSecret");
        this.enabled = enabled;
        this.endpoint = endpoint;
        this.appCode = appCode;
        this.appSecret = appSecret;
        this.port = port;
        this.externalHost = externalHost;
        this.externalPort = externalPort;
        this.destroyed = new AtomicBoolean(false);
        this.log = LoggerFactory.getLogger(PowerSchedulerWorker.class);
        this.serverDiscoveryService = new ServerDiscoveryService(this.endpoint);
        Integer n = this.externalPort;
        this.workerRegisterService = new WorkerRegisterService(this.appCode, this.appSecret, this.externalHost, n != null ? n : this.port, this.serverDiscoveryService);
        this.jobExecutorService = new JobExecutorService();
        ServerDiscoveryService serverDiscoveryService = this.serverDiscoveryService;
        WorkerRegisterService workerRegisterService = this.workerRegisterService;
        this.jobProgressReportService = new JobProgressReportService(workerRegisterService, serverDiscoveryService);
        this.embedServer = new EmbedServer(this.port, this.jobExecutorService);
    }

    public PowerSchedulerWorker(@NotNull PowerSchedulerWorkerProperties properties) {
        String string;
        String string2;
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        Boolean bl = properties.getEnabled();
        boolean bl2 = bl != null ? bl : true;
        Set set = properties.getServerEndpoint();
        if (set == null) {
            set = SetsKt.emptySet();
        }
        if ((string2 = properties.getAppCode()) == null) {
            string2 = "";
        }
        if ((string = properties.getAppSecret()) == null) {
            string = "";
        }
        Integer n = properties.getPort();
        Intrinsics.checkNotNull((Object)n);
        this(bl2, set, string2, string, n, properties.getExternalHost(), properties.getExternalPort());
    }

    public final void init() {
        if (!this.enabled) {
            return;
        }
        if (this.endpoint.isEmpty()) {
            throw new IllegalArgumentException("[PowerScheduler] endpoint cannot be empty");
        }
        if (StringsKt.isBlank((CharSequence)this.appCode)) {
            throw new IllegalArgumentException("[PowerScheduler] appCode is required");
        }
        if (StringsKt.isBlank((CharSequence)this.appSecret)) {
            throw new IllegalArgumentException("[PowerScheduler] appSecret is required");
        }
        this.initDatabase();
        this.embedServer.start();
        this.jobExecutorService.start();
        this.serverDiscoveryService.start();
        this.jobProgressReportService.start();
        this.workerRegisterService.start();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> PowerSchedulerWorker.init$lambda$0(this)));
    }

    public final void destroy() {
        if (this.destroyed.compareAndSet(false, true)) {
            this.embedServer.stop();
            this.jobExecutorService.stop();
            this.jobProgressReportService.stop();
            this.workerRegisterService.stop();
            this.serverDiscoveryService.stop();
            DataSourceManager.INSTANCE.closeDataSource();
            this.log.info("[PowerScheduler] {} stopped", (Object)this.getClass().getSimpleName());
        } else {
            this.log.debug("[PowerScheduler] {} has stopped", (Object)this.getClass().getSimpleName());
        }
    }

    private final void initDatabase() {
        String initSql = ClasspathUtil.readTextFrom("sql/power-scheduler-worker-init.sql");
        JdbcUtilKt.executeSql(initSql);
    }

    private static final void init$lambda$0(PowerSchedulerWorker this$0) {
        this$0.destroy();
    }
}

