/*
 * Decompiled with CFR 0.152.
 */
package tech.powerscheduler.worker;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlinx.coroutines.AwaitKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ChannelKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.powerscheduler.common.dto.request.JobProgressReportRequestDTO;
import tech.powerscheduler.common.dto.response.ResponseWrapper;
import tech.powerscheduler.worker.PowerSchedulerWorkerHttpClient;
import tech.powerscheduler.worker.ServerDiscoveryService;
import tech.powerscheduler.worker.WorkerRegisterService;
import tech.powerscheduler.worker.persistence.JobProgressEntity;
import tech.powerscheduler.worker.persistence.JobProgressRepository;
import tech.powerscheduler.worker.util.ExecutorCoroutineScope;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\u0012J\u0012\u0010\u0013\u001a\u00020\u0012*\u00020\u0014H\u0086@\u00a2\u0006\u0002\u0010\u0015J\u000e\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0018R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Ltech/powerscheduler/worker/JobProgressReportService;", "", "workerRegisterService", "Ltech/powerscheduler/worker/WorkerRegisterService;", "serverDiscoveryService", "Ltech/powerscheduler/worker/ServerDiscoveryService;", "<init>", "(Ltech/powerscheduler/worker/WorkerRegisterService;Ltech/powerscheduler/worker/ServerDiscoveryService;)V", "isActive", "", "httpClient", "Ltech/powerscheduler/worker/PowerSchedulerWorkerHttpClient;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "start", "Lkotlinx/coroutines/Job;", "stop", "", "reportProgress", "Lkotlinx/coroutines/CoroutineScope;", "(Lkotlinx/coroutines/CoroutineScope;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "doReportProgress", "taskId", "", "power-scheduler-worker"})
@SourceDebugExtension(value={"SMAP\nJobProgressReportService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JobProgressReportService.kt\ntech/powerscheduler/worker/JobProgressReportService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,120:1\n1563#2:121\n1634#2,3:122\n1068#2:125\n1617#2,9:126\n1869#2:135\n1870#2:137\n1626#2:138\n1#3:136\n*S KotlinDebug\n*F\n+ 1 JobProgressReportService.kt\ntech/powerscheduler/worker/JobProgressReportService\n*L\n75#1:121\n75#1:122,3\n97#1:125\n114#1:126,9\n114#1:135\n114#1:137\n114#1:138\n114#1:136\n*E\n"})
public final class JobProgressReportService {
    @NotNull
    private final WorkerRegisterService workerRegisterService;
    @NotNull
    private final ServerDiscoveryService serverDiscoveryService;
    private volatile boolean isActive;
    @NotNull
    private final PowerSchedulerWorkerHttpClient httpClient;
    private final Logger log;

    public JobProgressReportService(@NotNull WorkerRegisterService workerRegisterService, @NotNull ServerDiscoveryService serverDiscoveryService) {
        Intrinsics.checkNotNullParameter((Object)workerRegisterService, (String)"workerRegisterService");
        Intrinsics.checkNotNullParameter((Object)serverDiscoveryService, (String)"serverDiscoveryService");
        this.workerRegisterService = workerRegisterService;
        this.serverDiscoveryService = serverDiscoveryService;
        this.isActive = true;
        this.httpClient = new PowerSchedulerWorkerHttpClient();
        this.log = LoggerFactory.getLogger(JobProgressReportService.class);
    }

    @NotNull
    public final Job start() {
        return BuildersKt.launch$default((CoroutineScope)ExecutorCoroutineScope.INSTANCE, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ JobProgressReportService this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public final Object invokeSuspend(Object object) {
                Object object2;
                CoroutineScope $this$launch;
                Object object3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        $this$launch = (CoroutineScope)this.L$0;
                        break;
                    }
                    case 1: {
                        void $result;
                        $this$launch = (CoroutineScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        object2 = $result;
                    }
                    default: {
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }
                }
                while (CoroutineScopeKt.isActive((CoroutineScope)$this$launch)) {
                    try {
                        this.L$0 = $this$launch;
                        this.label = 1;
                        object2 = this.this$0.reportProgress($this$launch, (Continuation<? super Unit>)((Continuation)this));
                        if (object2 != object3) continue;
                    }
                    catch (CancellationException cancellationException) {
                        JobProgressReportService.access$getLog$p(this.this$0).info("[Powerscheduler] reportProgress canceled");
                    }
                    catch (Exception e) {
                        JobProgressReportService.access$getLog$p(this.this$0).warn("[Powerscheduler] reportProgress failed: {}", (Object)e.getMessage(), (Object)e);
                    }
                    return object3;
                }
                return Unit.INSTANCE;
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)function2;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    public final void stop() {
        this.isActive = false;
        ExecutorCoroutineScope.INSTANCE.cancelJobs();
        this.log.info("[PowerScheduler] {} stopped", (Object)this.getClass().getSimpleName());
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Object reportProgress(@NotNull CoroutineScope $this$reportProgress, @NotNull Continuation<? super Unit> $completion) {
        void $this$mapTo$iv$iv;
        Set<Long> taskIdSet = JobProgressRepository.INSTANCE.listDistinctJobInstanceIds();
        if (taskIdSet.isEmpty()) {
            Object object = DelayKt.delay((long)300L, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        if (this.serverDiscoveryService.getAvailableServerUrls().isEmpty()) {
            Object object = DelayKt.delay((long)300L, $completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }
        Channel channel = ChannelKt.Channel$default((int)10, null, null, (int)6, null);
        Iterable $this$map$iv = taskIdSet;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void taskId;
            long l = ((Number)item$iv$iv).longValue();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(BuildersKt.async$default((CoroutineScope)$this$reportProgress, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((Channel<Unit>)channel, this, (long)taskId, null){
                Object L$0;
                int label;
                final /* synthetic */ Channel<Unit> $channel;
                final /* synthetic */ JobProgressReportService this$0;
                final /* synthetic */ long $taskId;
                {
                    this.$channel = $channel;
                    this.this$0 = $receiver;
                    this.$taskId = $taskId;
                    super(2, $completion);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object var1_1) {
                    block16: {
                        var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)var1_1);
                                this.label = 1;
                                v0 = this.$channel.send((Object)Unit.INSTANCE, (Continuation)this);
                                ** if (v0 != var3_2) goto lbl11
lbl10:
                                // 1 sources

                                return var3_2;
lbl11:
                                // 1 sources

                                ** GOTO lbl17
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl17:
                                // 2 sources

                                this.this$0.doReportProgress(this.$taskId);
                                this.label = 2;
                                v1 = this.$channel.receive((Continuation)this);
                                if (v1 == var3_2) {
                                    return var3_2;
                                }
                                break;
                            }
                            case 2: {
                                ResultKt.throwOnFailure((Object)$result);
                                v1 = $result;
                                break;
                            }
                        }
                        catch (Exception e) {
                            JobProgressReportService.access$getLog$p(this.this$0).warn("[Powerscheduler] reportProgress failed: {}", (Object)e.getMessage(), (Object)e);
                            this.label = 3;
                            v2 = this.$channel.receive((Continuation)this);
                            if (v2 == var3_2) {
                                return var3_2;
                            }
                            break block16;
                        }
                        {
                            case 3: {
                                ResultKt.throwOnFailure((Object)$result);
                                v2 = $result;
                                break;
                            }
                        }
                        {
                            catch (Throwable var2_4) {
                                this.L$0 = var2_4;
                                this.label = 4;
                                v3 = this.$channel.receive((Continuation)this);
                                if (v3 == var3_2) {
                                    return var3_2;
                                }
                                ** GOTO lbl50
                            }
                        }
                        {
                            case 4: {
                                var2_5 = (Throwable)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v3 = $result;
lbl50:
                                // 2 sources

                                throw var2_5;
                            }
                        }
                    }
                    return Unit.INSTANCE;
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null));
        }
        List deferredList2 = (List)destination$iv$iv;
        Object object = AwaitKt.awaitAll((Collection)deferredList2, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    public final void doReportProgress(long taskId) {
        String serverUrl = (String)CollectionsKt.randomOrNull((Collection)this.serverDiscoveryService.getAvailableServerUrls(), (Random)((Random)Random.Default));
        if (serverUrl == null) {
            this.log.warn("[Powerscheduler] reportProgress failed: no available server]");
            return;
        }
        List<JobProgressEntity> jobProgressList = JobProgressRepository.INSTANCE.listByTaskId(taskId);
        Iterable $this$sortedByDescending$iv = jobProgressList;
        boolean $i$f$sortedByDescending = false;
        JobProgressEntity latestJobProgress = (JobProgressEntity)CollectionsKt.first((List)CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                JobProgressEntity it = (JobProgressEntity)b;
                boolean bl = false;
                Comparable comparable = it.getId();
                it = (JobProgressEntity)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)it.getId());
            }
        }));
        JobProgressReportRequestDTO $this$doReportProgress_u24lambda_u242 = $i$f$sortedByDescending = new JobProgressReportRequestDTO();
        boolean bl = false;
        $this$doReportProgress_u24lambda_u242.setJobInstanceId(latestJobProgress.getJobInstanceId());
        $this$doReportProgress_u24lambda_u242.setTaskId(latestJobProgress.getTaskId());
        $this$doReportProgress_u24lambda_u242.setStartAt(latestJobProgress.getStartAt());
        $this$doReportProgress_u24lambda_u242.setEndAt(latestJobProgress.getEndAt());
        $this$doReportProgress_u24lambda_u242.setTaskStatus(latestJobProgress.getStatus());
        $this$doReportProgress_u24lambda_u242.setMessage(latestJobProgress.getMessage());
        $this$doReportProgress_u24lambda_u242.setAppCode(this.workerRegisterService.getAppCode());
        $this$doReportProgress_u24lambda_u242.setAccessToken(this.workerRegisterService.getAccessToken());
        JobProgressReportRequestDTO param = $i$f$sortedByDescending;
        ResponseWrapper<Boolean> result = this.httpClient.reportProgress(serverUrl, param);
        if (result.getSuccess() && Intrinsics.areEqual((Object)result.getData(), (Object)true)) {
            void $this$mapNotNullTo$iv$iv;
            this.log.debug("[Powerscheduler] reportProgress successful: jobInstanceId={}, jobStatus={}", (Object)taskId, (Object)latestJobProgress.getStatus());
            Iterable $this$mapNotNull$iv = jobProgressList;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Long it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl2 = false;
                JobProgressEntity it = (JobProgressEntity)element$iv$iv;
                boolean bl3 = false;
                if (it.getId() == null) continue;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List ids = (List)destination$iv$iv;
            JobProgressRepository.INSTANCE.deleteByIds(ids);
        } else {
            this.log.warn("[Powerscheduler] reportProgress failed: {}", (Object)result.getMessage(), (Object)result.getCause());
        }
    }

    public static final /* synthetic */ Logger access$getLog$p(JobProgressReportService $this) {
        return $this.log;
    }
}

