/*
 * Decompiled with CFR 0.152.
 */
package tech.powerscheduler.worker.util;

import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0013\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0010J\r\u0010\u0011\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0013"}, d2={"Ltech/powerscheduler/worker/util/BoundedDelayQueue;", "E", "Ljava/util/concurrent/Delayed;", "", "capacity", "", "<init>", "(I)V", "delayQueue", "Ljava/util/concurrent/DelayQueue;", "size", "getSize", "()I", "offer", "", "e", "(Ljava/util/concurrent/Delayed;)Z", "poll", "()Ljava/util/concurrent/Delayed;", "power-scheduler-worker"})
public final class BoundedDelayQueue<E extends Delayed> {
    private final int capacity;
    @NotNull
    private final DelayQueue<E> delayQueue;

    public BoundedDelayQueue(int capacity) {
        this.capacity = capacity;
        this.delayQueue = new DelayQueue();
    }

    private final int getSize() {
        return this.delayQueue.size();
    }

    public final synchronized boolean offer(@NotNull E e) {
        Intrinsics.checkNotNullParameter(e, (String)"e");
        if (this.getSize() == this.capacity) {
            return false;
        }
        return this.delayQueue.offer(e);
    }

    @Nullable
    public final synchronized E poll() {
        Object item = this.delayQueue.poll();
        return (E)item;
    }
}

