/*
 * Decompiled with CFR 0.152.
 */
package tech.powerscheduler.worker.persistence;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.time.LocalDateTime;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import tech.powerscheduler.common.enums.JobStatusEnum;
import tech.powerscheduler.worker.persistence.DataSourceManager;
import tech.powerscheduler.worker.persistence.JobProgressEntity;
import tech.powerscheduler.worker.util.ClasspathUtil;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eJ\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u00112\u0006\u0010\u0012\u001a\u00020\u000fJ\u0014\u0010\u0013\u001a\u00020\n2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0015R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Ltech/powerscheduler/worker/persistence/JobProgressRepository;", "", "<init>", "()V", "insertSql", "", "deleteByIdSql", "listByJobInstanceIdSql", "listDistinctJobInstanceIdSql", "save", "", "entity", "Ltech/powerscheduler/worker/persistence/JobProgressEntity;", "listDistinctJobInstanceIds", "", "", "listByJobInstanceId", "", "jobInstanceId", "deleteByIds", "ids", "", "power-scheduler-worker"})
@SourceDebugExtension(value={"SMAP\nJobProgressRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JobProgressRepository.kt\ntech/powerscheduler/worker/persistence/JobProgressRepository\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,83:1\n1#2:84\n*E\n"})
public final class JobProgressRepository {
    @NotNull
    public static final JobProgressRepository INSTANCE = new JobProgressRepository();
    @NotNull
    private static final String insertSql = ClasspathUtil.readTextFrom("sql/job_progress/insert.sql");
    @NotNull
    private static final String deleteByIdSql = ClasspathUtil.readTextFrom("sql/job_progress/delete_by_id.sql");
    @NotNull
    private static final String listByJobInstanceIdSql = ClasspathUtil.readTextFrom("sql/job_progress/list_by_job_instance_id.sql");
    @NotNull
    private static final String listDistinctJobInstanceIdSql = ClasspathUtil.readTextFrom("sql/job_progress/list_distinct_job_instance_id.sql");

    private JobProgressRepository() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void save(@NotNull JobProgressEntity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        AutoCloseable autoCloseable = DataSourceManager.INSTANCE.getConnection();
        Throwable throwable = null;
        try {
            int n;
            Connection conn = (Connection)autoCloseable;
            boolean bl = false;
            AutoCloseable autoCloseable2 = conn.prepareStatement(insertSql);
            Throwable throwable2 = null;
            try {
                PreparedStatement stmt = (PreparedStatement)autoCloseable2;
                boolean bl2 = false;
                stmt.setObject(1, entity.getJobId());
                stmt.setObject(2, entity.getJobInstanceId());
                JobStatusEnum jobStatusEnum = entity.getStatus();
                stmt.setString(3, jobStatusEnum != null ? jobStatusEnum.name() : null);
                stmt.setObject(4, entity.getStartAt());
                stmt.setObject(5, entity.getEndAt());
                stmt.setString(6, entity.getMessage());
                n = stmt.executeUpdate();
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable2);
            }
            int n2 = n;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Set<Long> listDistinctJobInstanceIds() {
        Set set;
        AutoCloseable autoCloseable = DataSourceManager.INSTANCE.getConnection();
        Throwable throwable = null;
        try {
            Set set2;
            Connection conn = (Connection)autoCloseable;
            boolean bl = false;
            AutoCloseable autoCloseable2 = conn.prepareStatement(listDistinctJobInstanceIdSql);
            Throwable throwable2 = null;
            try {
                Set set3;
                PreparedStatement stmt = (PreparedStatement)autoCloseable2;
                boolean bl2 = false;
                AutoCloseable autoCloseable3 = stmt.executeQuery();
                Throwable throwable3 = null;
                try {
                    ResultSet rs = (ResultSet)autoCloseable3;
                    boolean bl3 = false;
                    set3 = SequencesKt.toSet((Sequence)SequencesKt.generateSequence(() -> JobProgressRepository.listDistinctJobInstanceIds$lambda$6$lambda$5$lambda$4$lambda$3(rs)));
                }
                catch (Throwable throwable4) {
                    throwable3 = throwable4;
                    throw throwable4;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable3, (Throwable)throwable3);
                }
                set2 = set3;
            }
            catch (Throwable throwable5) {
                throwable2 = throwable5;
                throw throwable5;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable2);
            }
            set = set2;
        }
        catch (Throwable throwable6) {
            throwable = throwable6;
            throw throwable6;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<JobProgressEntity> listByJobInstanceId(long jobInstanceId) {
        List list;
        AutoCloseable autoCloseable = DataSourceManager.INSTANCE.getConnection();
        Throwable throwable = null;
        try {
            List list2;
            Connection conn = (Connection)autoCloseable;
            boolean bl = false;
            AutoCloseable autoCloseable2 = conn.prepareStatement(listByJobInstanceIdSql);
            Throwable throwable2 = null;
            try {
                List list3;
                PreparedStatement stmt = (PreparedStatement)autoCloseable2;
                boolean bl2 = false;
                stmt.setLong(1, jobInstanceId);
                AutoCloseable autoCloseable3 = stmt.executeQuery();
                Throwable throwable3 = null;
                try {
                    ResultSet rs = (ResultSet)autoCloseable3;
                    boolean bl3 = false;
                    list3 = SequencesKt.toList((Sequence)SequencesKt.generateSequence(() -> JobProgressRepository.listByJobInstanceId$lambda$12$lambda$11$lambda$10$lambda$9(rs)));
                }
                catch (Throwable throwable4) {
                    throwable3 = throwable4;
                    throw throwable4;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable3, (Throwable)throwable3);
                }
                list2 = list3;
            }
            catch (Throwable throwable5) {
                throwable2 = throwable5;
                throw throwable5;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable2);
            }
            list = list2;
        }
        catch (Throwable throwable6) {
            throwable = throwable6;
            throw throwable6;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void deleteByIds(@NotNull Iterable<Long> ids) {
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        AutoCloseable autoCloseable = DataSourceManager.INSTANCE.getConnection();
        Throwable throwable = null;
        try {
            int[] nArray;
            Connection conn = (Connection)autoCloseable;
            boolean bl = false;
            AutoCloseable autoCloseable2 = conn.prepareStatement(deleteByIdSql);
            Throwable throwable2 = null;
            try {
                PreparedStatement stmt = (PreparedStatement)autoCloseable2;
                boolean bl2 = false;
                Iterator<Long> iterator = ids.iterator();
                while (iterator.hasNext()) {
                    long id = ((Number)iterator.next()).longValue();
                    stmt.setLong(1, id);
                    stmt.addBatch();
                }
                nArray = stmt.executeBatch();
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable2, (Throwable)throwable2);
            }
            int[] nArray2 = nArray;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    private static final Long listDistinctJobInstanceIds$lambda$6$lambda$5$lambda$4$lambda$3(ResultSet $rs) {
        ResultSet resultSet;
        ResultSet it = resultSet = $rs;
        boolean bl = false;
        ResultSet resultSet2 = it.next() ? resultSet : null;
        return resultSet2 != null ? Long.valueOf(resultSet2.getLong("job_instance_id")) : null;
    }

    /*
     * WARNING - void declaration
     */
    private static final JobProgressEntity listByJobInstanceId$lambda$12$lambda$11$lambda$10$lambda$9(ResultSet $rs) {
        JobProgressEntity jobProgressEntity;
        if ($rs.next()) {
            JobStatusEnum jobStatusEnum;
            JobProgressEntity jobProgressEntity2;
            JobProgressEntity $this$listByJobInstanceId_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410_u24lambda_u249_u24lambda_u248 = jobProgressEntity2 = new JobProgressEntity();
            boolean bl = false;
            $this$listByJobInstanceId_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410_u24lambda_u249_u24lambda_u248.setId($rs.getLong("id"));
            $this$listByJobInstanceId_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410_u24lambda_u249_u24lambda_u248.setJobId($rs.getLong("job_id"));
            $this$listByJobInstanceId_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410_u24lambda_u249_u24lambda_u248.setJobInstanceId($rs.getLong("job_instance_id"));
            JobProgressEntity jobProgressEntity3 = $this$listByJobInstanceId_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410_u24lambda_u249_u24lambda_u248;
            String string = $rs.getString("status");
            if (string != null) {
                void it;
                String string2 = string;
                JobProgressEntity jobProgressEntity4 = jobProgressEntity3;
                boolean bl2 = false;
                jobStatusEnum = JobStatusEnum.valueOf((String)it);
                jobProgressEntity3 = jobProgressEntity4;
            } else {
                jobStatusEnum = null;
            }
            jobProgressEntity3.setStatus(jobStatusEnum);
            $this$listByJobInstanceId_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410_u24lambda_u249_u24lambda_u248.setStartAt($rs.getObject("start_at", LocalDateTime.class));
            $this$listByJobInstanceId_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410_u24lambda_u249_u24lambda_u248.setEndAt($rs.getObject("end_at", LocalDateTime.class));
            $this$listByJobInstanceId_u24lambda_u2412_u24lambda_u2411_u24lambda_u2410_u24lambda_u249_u24lambda_u248.setMessage($rs.getString("message"));
            jobProgressEntity = jobProgressEntity2;
        } else {
            jobProgressEntity = null;
        }
        return jobProgressEntity;
    }
}

