/*
 * Decompiled with CFR 0.152.
 */
package tech.powerscheduler.worker.job;

import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Comparator;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.powerscheduler.common.enums.JobStatusEnum;
import tech.powerscheduler.worker.exception.PowerSchedulerWorkerException;
import tech.powerscheduler.worker.job.JobContext;
import tech.powerscheduler.worker.persistence.JobProgressEntity;
import tech.powerscheduler.worker.persistence.JobProgressRepository;
import tech.powerscheduler.worker.processor.ProcessResult;
import tech.powerscheduler.worker.processor.Processor;
import tech.powerscheduler.worker.processor.ProcessorRegistry;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0006\u0010(\u001a\u00020)J\u0006\u0010*\u001a\u00020)J\u001c\u0010+\u001a\u00020)2\u0006\u0010\u001b\u001a\u00020\u001c2\n\b\u0002\u0010,\u001a\u0004\u0018\u00010\u0007H\u0002J\u0010\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0016J\u0013\u00101\u001a\u00020\t2\b\u00102\u001a\u0004\u0018\u00010\u0001H\u0096\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0014\u001a\n \u0016*\u0004\u0018\u00010\u00150\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001b\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001c\u0010!\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u000f\"\u0004\b#\u0010$R\u001c\u0010%\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u000f\"\u0004\b'\u0010$\u00a8\u00063"}, d2={"Ltech/powerscheduler/worker/job/Job;", "Ljava/util/concurrent/Delayed;", "context", "Ltech/powerscheduler/worker/job/JobContext;", "scheduleAt", "Ljava/time/LocalDateTime;", "processorPath", "", "priority", "", "<init>", "(Ltech/powerscheduler/worker/job/JobContext;Ljava/time/LocalDateTime;Ljava/lang/String;I)V", "getContext", "()Ltech/powerscheduler/worker/job/JobContext;", "getScheduleAt", "()Ljava/time/LocalDateTime;", "getProcessorPath", "()Ljava/lang/String;", "getPriority", "()I", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "workerThread", "Ljava/lang/Thread;", "terminated", "", "jobStatus", "Ltech/powerscheduler/common/enums/JobStatusEnum;", "getJobStatus", "()Ltech/powerscheduler/common/enums/JobStatusEnum;", "setJobStatus", "(Ltech/powerscheduler/common/enums/JobStatusEnum;)V", "startAt", "getStartAt", "setStartAt", "(Ljava/time/LocalDateTime;)V", "endAt", "getEndAt", "setEndAt", "execute", "", "terminate", "updateProgress", "message", "getDelay", "", "unit", "Ljava/util/concurrent/TimeUnit;", "compareTo", "other", "power-scheduler-worker"})
public final class Job
implements Delayed {
    @NotNull
    private final JobContext context;
    @NotNull
    private final LocalDateTime scheduleAt;
    @NotNull
    private final String processorPath;
    private final int priority;
    private final Logger log;
    @Nullable
    private Thread workerThread;
    private volatile boolean terminated;
    @NotNull
    private JobStatusEnum jobStatus;
    @Nullable
    private LocalDateTime startAt;
    @Nullable
    private LocalDateTime endAt;

    public Job(@NotNull JobContext context, @NotNull LocalDateTime scheduleAt, @NotNull String processorPath, int priority) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)scheduleAt, (String)"scheduleAt");
        Intrinsics.checkNotNullParameter((Object)processorPath, (String)"processorPath");
        this.context = context;
        this.scheduleAt = scheduleAt;
        this.processorPath = processorPath;
        this.priority = priority;
        this.log = LoggerFactory.getLogger((String)Reflection.getOrCreateKotlinClass(Job.class).getQualifiedName());
        this.jobStatus = JobStatusEnum.PENDING;
    }

    @NotNull
    public final JobContext getContext() {
        return this.context;
    }

    @NotNull
    public final LocalDateTime getScheduleAt() {
        return this.scheduleAt;
    }

    @NotNull
    public final String getProcessorPath() {
        return this.processorPath;
    }

    public final int getPriority() {
        return this.priority;
    }

    @NotNull
    public final JobStatusEnum getJobStatus() {
        return this.jobStatus;
    }

    public final void setJobStatus(@NotNull JobStatusEnum jobStatusEnum) {
        Intrinsics.checkNotNullParameter((Object)jobStatusEnum, (String)"<set-?>");
        this.jobStatus = jobStatusEnum;
    }

    @Nullable
    public final LocalDateTime getStartAt() {
        return this.startAt;
    }

    public final void setStartAt(@Nullable LocalDateTime localDateTime) {
        this.startAt = localDateTime;
    }

    @Nullable
    public final LocalDateTime getEndAt() {
        return this.endAt;
    }

    public final void setEndAt(@Nullable LocalDateTime localDateTime) {
        this.endAt = localDateTime;
    }

    public final void execute() {
        block9: {
            this.startAt = LocalDateTime.now();
            this.workerThread = Thread.currentThread();
            Job.updateProgress$default(this, JobStatusEnum.PROCESSING, null, 2, null);
            try {
                if (this.terminated) {
                    throw new PowerSchedulerWorkerException("[Powerscheduler] Job is terminated", null, 2, null);
                }
                Processor processor = ProcessorRegistry.find(this.processorPath);
                if (processor == null) {
                    throw new PowerSchedulerWorkerException("[Powerscheduler] Processor [" + this.processorPath + "] not exists", null, 2, null);
                }
                Processor processor2 = processor;
                ProcessResult result = processor2.process(this.context);
                ProcessResult processResult = result;
                if (processResult instanceof ProcessResult.Success) {
                    Job.updateProgress$default(this, JobStatusEnum.SUCCESS, null, 2, null);
                    break block9;
                }
                if (processResult instanceof ProcessResult.Failure) {
                    this.updateProgress(JobStatusEnum.FAILED, ((ProcessResult.Failure)result).getMessage());
                    break block9;
                }
                if (processResult == null) {
                    throw new PowerSchedulerWorkerException("[Powerscheduler] ProcessResult can not be null", null, 2, null);
                }
                throw new NoWhenBranchMatchedException();
            }
            catch (InterruptedException interruptedException) {
                this.log.error("[Powerscheduler] execution of jobInstance [{}] is canceled", (Object)this.context.getJobInstanceId());
                Job.updateProgress$default(this, JobStatusEnum.FAILED, null, 2, null);
            }
            catch (PowerSchedulerWorkerException e) {
                Object[] objectArray = new Object[]{this.context.getJobInstanceId(), e.getMessage(), e};
                this.log.error("[Powerscheduler] Error while executing jobInstance [{}]: {}", objectArray);
                this.updateProgress(JobStatusEnum.FAILED, e.getMessage());
            }
            catch (Throwable e) {
                this.log.error("[Powerscheduler] Error while executing jobInstance [{}]", (Object)this.context.getJobInstanceId(), (Object)e);
                this.updateProgress(JobStatusEnum.FAILED, ExceptionsKt.stackTraceToString((Throwable)e));
            }
        }
    }

    public final void terminate() {
        block0: {
            this.terminated = false;
            Thread thread = this.workerThread;
            if (thread == null) break block0;
            thread.interrupt();
        }
    }

    private final void updateProgress(JobStatusEnum jobStatus, String message) {
        JobProgressEntity jobProgressEntity;
        this.jobStatus = jobStatus;
        if (JobStatusEnum.Companion.getCOMPLETED_STATUSES().contains(jobStatus)) {
            this.endAt = LocalDateTime.now();
        }
        JobProgressEntity it = jobProgressEntity = new JobProgressEntity();
        boolean bl = false;
        Long l = this.context.getJobId();
        Intrinsics.checkNotNull((Object)l);
        it.setJobId(l);
        Long l2 = this.context.getJobInstanceId();
        Intrinsics.checkNotNull((Object)l2);
        it.setJobInstanceId(l2);
        it.setStatus(this.jobStatus);
        it.setStartAt(this.startAt);
        it.setEndAt(this.endAt);
        it.setMessage(message);
        JobProgressEntity jobProgressEntity2 = jobProgressEntity;
        JobProgressRepository.INSTANCE.save(jobProgressEntity2);
    }

    static /* synthetic */ void updateProgress$default(Job job, JobStatusEnum jobStatusEnum, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = "";
        }
        job.updateProgress(jobStatusEnum, string);
    }

    @Override
    public long getDelay(@NotNull TimeUnit unit) {
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        long delay = ChronoUnit.MILLIS.between(LocalDateTime.now(), this.scheduleAt);
        return unit.convert(delay, TimeUnit.MILLISECONDS);
    }

    @Override
    public int compareTo(@Nullable Delayed other) {
        if (other == this) {
            return 0;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type tech.powerscheduler.worker.job.Job");
        Job otherJob = (Job)other;
        return Comparator.comparing(arg_0 -> Job.compareTo$lambda$2(Job::compareTo$lambda$1, arg_0)).thenComparing(Comparator.comparingInt(arg_0 -> Job.compareTo$lambda$4(Job::compareTo$lambda$3, arg_0)).reversed()).compare(this, otherJob);
    }

    private static final LocalDateTime compareTo$lambda$1(Job it) {
        Job job = it;
        Intrinsics.checkNotNull((Object)job);
        return job.scheduleAt;
    }

    private static final LocalDateTime compareTo$lambda$2(Function1 $tmp0, Object p0) {
        return (LocalDateTime)$tmp0.invoke(p0);
    }

    private static final int compareTo$lambda$3(Job obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        return obj.priority;
    }

    private static final int compareTo$lambda$4(Function1 $tmp0, Object p0) {
        return ((Number)$tmp0.invoke(p0)).intValue();
    }
}

