/*
 * Decompiled with CFR 0.152.
 */
package tech.powerscheduler.worker;

import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.powerscheduler.common.dto.request.WorkerHeartbeatRequestDTO;
import tech.powerscheduler.common.dto.request.WorkerRegisterRequestDTO;
import tech.powerscheduler.common.dto.request.WorkerUnregisterRequestDTO;
import tech.powerscheduler.common.dto.response.ResponseWrapper;
import tech.powerscheduler.worker.PowerSchedulerWorkerHttpClient;
import tech.powerscheduler.worker.ServerDiscoveryService;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\u0017J\u0006\u0010\u0019\u001a\u00020\u0017J\u0006\u0010\u001a\u001a\u00020\u0017J\u0006\u0010\u001b\u001a\u00020\u0017J\u0006\u0010\u001c\u001a\u00020\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\n \u0015*\u0004\u0018\u00010\u00140\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Ltech/powerscheduler/worker/WorkerRegisterService;", "", "appCode", "", "appSecret", "host", "port", "", "serverDiscoveryService", "Ltech/powerscheduler/worker/ServerDiscoveryService;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ILtech/powerscheduler/worker/ServerDiscoveryService;)V", "accessToken", "registered", "", "httpClient", "Ltech/powerscheduler/worker/PowerSchedulerWorkerHttpClient;", "scheduledThreadPoolExecutor", "Ljava/util/concurrent/ScheduledThreadPoolExecutor;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "start", "", "stop", "registerOrKeepAlive", "register", "heartbeat", "unregister", "power-scheduler-worker"})
public final class WorkerRegisterService {
    @NotNull
    private final String appCode;
    @NotNull
    private final String appSecret;
    @Nullable
    private final String host;
    private final int port;
    @NotNull
    private final ServerDiscoveryService serverDiscoveryService;
    @NotNull
    private volatile String accessToken;
    private boolean registered;
    @NotNull
    private final PowerSchedulerWorkerHttpClient httpClient;
    @NotNull
    private final ScheduledThreadPoolExecutor scheduledThreadPoolExecutor;
    private final Logger log;

    public WorkerRegisterService(@NotNull String appCode, @NotNull String appSecret, @Nullable String host, int port, @NotNull ServerDiscoveryService serverDiscoveryService) {
        Intrinsics.checkNotNullParameter((Object)appCode, (String)"appCode");
        Intrinsics.checkNotNullParameter((Object)appSecret, (String)"appSecret");
        Intrinsics.checkNotNullParameter((Object)serverDiscoveryService, (String)"serverDiscoveryService");
        this.appCode = appCode;
        this.appSecret = appSecret;
        this.host = host;
        this.port = port;
        this.serverDiscoveryService = serverDiscoveryService;
        this.accessToken = "";
        this.httpClient = new PowerSchedulerWorkerHttpClient();
        this.scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(1);
        this.log = LoggerFactory.getLogger(WorkerRegisterService.class);
    }

    public final void start() {
        this.scheduledThreadPoolExecutor.scheduleWithFixedDelay(this::registerOrKeepAlive, 0L, 1L, TimeUnit.SECONDS);
    }

    public final void stop() {
        this.scheduledThreadPoolExecutor.shutdown();
        this.unregister();
    }

    public final void registerOrKeepAlive() {
        if (this.registered) {
            this.heartbeat();
        } else {
            this.register();
        }
    }

    public final void register() {
        WorkerRegisterRequestDTO workerRegisterRequestDTO;
        Set<String> availableServerUrls = this.serverDiscoveryService.getAvailableServerUrls();
        String serverUrl = (String)CollectionsKt.randomOrNull((Collection)availableServerUrls, (Random)((Random)Random.Default));
        CharSequence charSequence = serverUrl;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            this.log.warn("[PowerScheduler] register failed, no available server");
            return;
        }
        WorkerRegisterRequestDTO it = workerRegisterRequestDTO = new WorkerRegisterRequestDTO();
        boolean bl = false;
        it.setAppCode(this.appCode);
        it.setAppSecret(this.appSecret);
        it.setHost(this.host);
        it.setPort(Integer.valueOf(this.port));
        WorkerRegisterRequestDTO param = workerRegisterRequestDTO;
        ResponseWrapper<String> result = this.httpClient.register(serverUrl, param);
        if (result.getSuccess()) {
            this.registered = true;
            String string = (String)result.getData();
            if (string == null) {
                string = "";
            }
            this.accessToken = string;
            this.log.info("[PowerScheduler] registered successfully");
        } else {
            this.registered = false;
            Object[] objectArray = new Object[]{serverUrl, result.getMessage(), result.getCause()};
            this.log.error("[PowerScheduler] register fail: server={}, msg={}", objectArray);
        }
    }

    public final void heartbeat() {
        WorkerHeartbeatRequestDTO workerHeartbeatRequestDTO;
        Set<String> availableServerUrls = this.serverDiscoveryService.getAvailableServerUrls();
        String serverUrl = (String)CollectionsKt.random((Collection)availableServerUrls, (Random)((Random)Random.Default));
        WorkerHeartbeatRequestDTO it = workerHeartbeatRequestDTO = new WorkerHeartbeatRequestDTO();
        boolean bl = false;
        it.setAppCode(this.appCode);
        it.setAccessToken(this.accessToken);
        it.setHost(this.host);
        it.setPort(Integer.valueOf(this.port));
        WorkerHeartbeatRequestDTO param = workerHeartbeatRequestDTO;
        ResponseWrapper<Boolean> result = this.httpClient.heartbeat(serverUrl, param);
        if (result.getSuccess() && Intrinsics.areEqual((Object)result.getData(), (Object)true)) {
            this.registered = true;
        } else {
            this.registered = false;
            Object[] objectArray = new Object[]{serverUrl, result.getMessage(), result.getCause()};
            this.log.error("[PowerScheduler] heartbeat failed: server={}, msg={}", objectArray);
        }
    }

    public final void unregister() {
        WorkerUnregisterRequestDTO workerUnregisterRequestDTO;
        this.registered = false;
        this.scheduledThreadPoolExecutor.shutdown();
        Set<String> availableServerUrls = this.serverDiscoveryService.getAvailableServerUrls();
        if (availableServerUrls.isEmpty()) {
            this.log.info("[PowerScheduler] unregister failed, no available server");
            return;
        }
        String serverUrl = (String)CollectionsKt.random((Collection)availableServerUrls, (Random)((Random)Random.Default));
        WorkerUnregisterRequestDTO it = workerUnregisterRequestDTO = new WorkerUnregisterRequestDTO();
        boolean bl = false;
        it.setAppCode(this.appCode);
        it.setAccessToken(this.accessToken);
        it.setHost(this.host);
        it.setPort(Integer.valueOf(this.port));
        WorkerUnregisterRequestDTO param = workerUnregisterRequestDTO;
        ResponseWrapper<Boolean> result = this.httpClient.unregister(serverUrl, param);
        if (result.getSuccess() && Intrinsics.areEqual((Object)result.getData(), (Object)true)) {
            this.log.info("[PowerScheduler] unregister success");
        } else {
            Object[] objectArray = new Object[]{serverUrl, result.getMessage(), result.getCause()};
            this.log.error("[PowerScheduler] unregister failed: server={}, msg={}", objectArray);
        }
    }
}

