/*
 * Decompiled with CFR 0.152.
 */
package tech.powerscheduler.worker;

import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.powerscheduler.common.dto.request.JobDispatchRequestDTO;
import tech.powerscheduler.common.dto.request.JobTerminateRequestDTO;
import tech.powerscheduler.common.enums.JobStatusEnum;
import tech.powerscheduler.common.enums.JobTypeEnum;
import tech.powerscheduler.worker.job.Job;
import tech.powerscheduler.worker.job.JobContext;
import tech.powerscheduler.worker.job.ScriptJobContext;
import tech.powerscheduler.worker.persistence.JobProgressEntity;
import tech.powerscheduler.worker.persistence.JobProgressRepository;
import tech.powerscheduler.worker.util.BasicThreadFactory;
import tech.powerscheduler.worker.util.BoundedDelayQueue;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u0013J\b\u0010\u0015\u001a\u00020\u0013H\u0002J\u000e\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0006\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007j\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Ltech/powerscheduler/worker/JobExecutorService;", "", "<init>", "()V", "scheduledThreadPoolExecutor", "Ljava/util/concurrent/ScheduledThreadPoolExecutor;", "jobRegistry", "Ljava/util/HashMap;", "", "Ltech/powerscheduler/worker/job/Job;", "Lkotlin/collections/HashMap;", "jobQueue", "Ltech/powerscheduler/worker/util/BoundedDelayQueue;", "workerThreadPool", "Ljava/util/concurrent/ThreadPoolExecutor;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "start", "", "stop", "onTick", "schedule", "command", "Ltech/powerscheduler/common/dto/request/JobDispatchRequestDTO;", "terminate", "param", "Ltech/powerscheduler/common/dto/request/JobTerminateRequestDTO;", "power-scheduler-worker"})
public final class JobExecutorService {
    @NotNull
    private final ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(1);
    @NotNull
    private final HashMap<Long, Job> jobRegistry = new HashMap();
    @NotNull
    private final BoundedDelayQueue<Job> jobQueue = new BoundedDelayQueue(1000);
    @NotNull
    private final ThreadPoolExecutor workerThreadPool = new ThreadPoolExecutor(10, 10, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue(1000), new BasicThreadFactory("PS-Worker-"), new ThreadPoolExecutor.AbortPolicy());
    private final Logger log = LoggerFactory.getLogger(JobExecutorService.class);

    public final void start() {
        this.scheduledThreadPoolExecutor.scheduleWithFixedDelay(this::onTick, 1L, 1L, TimeUnit.SECONDS);
    }

    public final void stop() {
        this.scheduledThreadPoolExecutor.shutdown();
        this.log.info("[PowerScheduler] {} stopped", (Object)this.getClass().getSimpleName());
    }

    private final void onTick() {
        Job job;
        while ((job = this.jobQueue.poll()) != null) {
            this.workerThreadPool.execute(() -> JobExecutorService.onTick$lambda$0(job));
        }
    }

    public final void schedule(@NotNull JobDispatchRequestDTO command) {
        JobProgressEntity jobProgressEntity;
        JobContext jobContext;
        JobContext jobContext2;
        JobContext jobContext3;
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Long l = command.getJobInstanceId();
        Intrinsics.checkNotNull((Object)l);
        long jobInstanceId = l;
        if (command.getJobType() == JobTypeEnum.SCRIPT) {
            jobContext3 = new ScriptJobContext();
            ScriptJobContext $this$schedule_u24lambda_u241 = jobContext3;
            boolean bl = false;
            $this$schedule_u24lambda_u241.setScriptType(command.getScriptType());
            $this$schedule_u24lambda_u241.setScriptCode(command.getScriptCode());
            jobContext2 = jobContext3;
        } else {
            jobContext2 = new JobContext();
        }
        JobContext it = jobContext3 = (jobContext = jobContext2);
        boolean bl = false;
        it.setJobId(command.getJobId());
        it.setJobInstanceId(jobInstanceId);
        it.setExecuteParams(command.getExecuteParams());
        it.setDataTime(command.getDataTime());
        LocalDateTime localDateTime = command.getScheduleAt();
        Intrinsics.checkNotNull((Object)localDateTime);
        String string = command.getProcessor();
        Intrinsics.checkNotNull((Object)string);
        Job job = new Job(jobContext, localDateTime, string, command.getPriority());
        JobProgressEntity it2 = jobProgressEntity = new JobProgressEntity();
        boolean bl2 = false;
        it2.setJobId(command.getJobId());
        Long l2 = command.getJobInstanceId();
        Intrinsics.checkNotNull((Object)l2);
        it2.setJobInstanceId(l2);
        JobProgressEntity jobProgressEntity2 = jobProgressEntity;
        if (!this.jobQueue.offer((Job)((Delayed)job))) {
            job.terminate();
            it2 = jobProgressEntity = jobProgressEntity2;
            boolean bl3 = false;
            it2.setStartAt(LocalDateTime.now());
            it2.setStartAt(LocalDateTime.now());
            it2.setStatus(JobStatusEnum.FAILED);
            it2.setMessage("job queue is full");
        } else {
            this.jobRegistry.put(jobInstanceId, job);
            jobProgressEntity2.setStatus(JobStatusEnum.PENDING);
        }
        JobProgressRepository.INSTANCE.save(jobProgressEntity2);
    }

    public final void terminate(@NotNull JobTerminateRequestDTO param) {
        block0: {
            Job job;
            Intrinsics.checkNotNullParameter((Object)param, (String)"param");
            Map map = this.jobRegistry;
            Long l = param.getJobInstanceId();
            Job job2 = job = (Job)TypeIntrinsics.asMutableMap((Object)map).remove(l);
            if (job2 == null) break block0;
            job2.terminate();
        }
    }

    private static final void onTick$lambda$0(Job $job) {
        $job.execute();
    }
}

