/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.agent;

import com.google.common.base.Splitter;
import java.util.ArrayList;
import lombok.Generated;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;
import tech.powerjob.common.enums.Protocol;
import tech.powerjob.worker.PowerJobWorker;
import tech.powerjob.worker.common.PowerJobWorkerConfig;
import tech.powerjob.worker.common.constants.StoreStrategy;

@CommandLine.Command(name="PowerJobAgent", mixinStandardHelpOptions=true, version={"4.3.0"}, description={"powerjob-worker agent"})
public class MainApplication
implements Runnable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MainApplication.class);
    @CommandLine.Option(names={"-a", "--app"}, description={"worker-agent's name"}, required=true)
    private String appName;
    @CommandLine.Option(names={"-p", "--port"}, description={"transporter working port, not recommended to change"})
    private Integer port = 27777;
    @CommandLine.Option(names={"-o", "--protocol"}, description={"transporter protocol, AKKA or HTTP"})
    private String protocol = Protocol.AKKA.name();
    @CommandLine.Option(names={"-e", "--persistence"}, description={"storage strategy, DISK or MEMORY"})
    private String storeStrategy = "DISK";
    @CommandLine.Option(names={"-s", "--server"}, description={"oms-server's address, IP:Port OR domain"}, required=true)
    private String server = "localhost:7700";
    @CommandLine.Option(names={"-l", "--length"}, description={"ProcessResult#msg max length"})
    private int length = 1024;
    @CommandLine.Option(names={"-t", "--tag"}, description={"worker-agent's tag"})
    private String tag;

    public static void main(String[] args) {
        CommandLine commandLine = new CommandLine((Object)new MainApplication());
        commandLine.execute(args);
    }

    @Override
    public void run() {
        PowerJobWorkerConfig cfg = new PowerJobWorkerConfig();
        try {
            cfg.setAppName(this.appName);
            cfg.setPort(this.port.intValue());
            ArrayList servers = new ArrayList(Splitter.on((String)",").splitToList((CharSequence)this.server));
            cfg.setServerAddress(servers);
            cfg.setStoreStrategy(StoreStrategy.MEMORY.name().equals(this.storeStrategy) ? StoreStrategy.MEMORY : StoreStrategy.DISK);
            cfg.setMaxResultLength(this.length);
            cfg.setTag(this.tag);
            cfg.setProtocol(Protocol.of((String)this.protocol));
            PowerJobWorker worker = new PowerJobWorker(cfg);
            worker.init();
        }
        catch (Exception e) {
            log.error("[PowerJobAgent] startup failed by config: {}.", (Object)cfg, (Object)e);
            ExceptionUtils.rethrow((Throwable)e);
        }
    }
}

